/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

Legato.Control.ScaleInput = OpenLayers.Class(OpenLayers.Control, {
      element :null,
      labelElement :null,
      inputElement :null,
      format: null,
      initialize : function(options) {
        OpenLayers.Control.prototype.initialize.apply(this, [ options ]);
        if (!Legato.Lang.ObjectUtils.exists(this.format))
        {
          this.format = new Legato.Text.PrecisionScaleFormat(3,0);
        }
      },
      draw : function() {
        var div = OpenLayers.Control.prototype.draw.apply(this, arguments);
        if (!Legato.Lang.ObjectUtils.exists(this.element)) {
          this.element = document.createElement('div');
          this.element.id = this.id + "_Element";
          this.element.className = this.displayClass + 'Element';
          div.appendChild(this.element);
        }
        if (!Legato.Lang.ObjectUtils.exists(this.labelElement)) {
          this.labelElement = document.createElement('span');
          this.labelElement.id = this.id + "_LabelElement";
          this.labelElement.className = this.displayClass + 'LabelElement';
          this.labelElement.innerHTML = '1:';
          this.element.appendChild(this.labelElement);
        }
        if (!Legato.Lang.ObjectUtils.exists(this.inputElement)) {
          this.inputElement = document.createElement('input');
          this.inputElement.id = this.id + "_InputElement";
          this.inputElement.name = this.id + "_InputElement";
          this.inputElement.className = this.displayClass + 'InputElement';
          this.inputElement.type = 'text';
          this.element.appendChild(this.inputElement);
        }
        this.updateInput();
        this.inputElement.onchange = OpenLayers.Function.bindAsEventListener(this.updateMap,
            this);

        OpenLayers.Event.observe(
            this.inputElement,
            'keypress',
            OpenLayers.Function.bindAsEventListener(function(event){
              if(event.keyCode == OpenLayers.Event.KEY_RETURN) {
                this.updateMap();
              }
            }, this)
        );

        return div;
      },

      updateInput : function() {
        var scale = this.getScale();
        if (Legato.Lang.ObjectUtils.exists(scale)) {
          this.inputElement.value = scale;
        }
      },

      updateMap : function() {
        var value = this.inputElement.value;
        var scale = this.format.parse(value);
        if (isNaN(scale)) {
        } else {
          this.setScale(scale, true);
        }
        this.updateInput();
      },
      getScale : function() {
        var mapScale = this.map.getScale();
        if (Legato.Lang.ObjectUtils.isNumber(mapScale)) {
          return this.format.format(mapScale);
        } else {
          return null;
        }
      },
      setScale : function(scale) {
        this.map.zoomToScale(scale, true);
      },
      setMap : function(map) {
        OpenLayers.Control.prototype.setMap.apply(this, arguments);
        this.map.events.on( {
          'zoomend' :this.updateInput,
          'changebaselayer' :this.updateInput,
          scope :this
        });
      },
      destroy : function() {
        if (this.inputElement !== null) {
          this.inputElement.onchange = null;
        }
        this.map.events.un( {
          'zoomend' :this.updateInput,
          'changebaselayer' :this.updateInput,
          scope :this
        });
        this.inputElement = null;
        this.labelElement = null;
        OpenLayers.Control.prototype.destroy.apply(this, arguments);
      },
      CLASS_NAME :"Legato.Control.ScaleInput"
    });

Legato.Control.ScaleInput.Bean = OpenLayers.Control.Bean.Extend(

'Legato.Control.ScaleInput',

Legato.Control.QName('ScaleInput'), {
  _constructor :Legato.Control.ScaleInput,
  options : {
    labelElement :Legato.Lang.Element,
    inputElement :Legato.Lang.Element,
    scale :Legato.Lang.Integer
  }
});
