/*
 * Legato is a configurable, lightweight web mapping client that can be
 * easily embedded into web pages and portals, CMS and individual web
 * applications. Legato is implemented in JavaScript and based on the
 * popular open source library OpenLayers.
 *
 * Copyright (C) 2010  disy Informationssysteme GmbH, http://www.disy.net
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

///**
// * @author $Author: valikov $
// * @version $Rev: 70190 $
// * @base Legato.Control
// * @requires Legato/Control.js
// */
//
///**
// * Class: Legato.Control.Legend.Plugin.LayerLegend
// * Renders the legendUrl Image if exists
// *
// * Inherits from: - <Legato.Control.Legend.Plugin>
// */
//Legato.Control.Legend.Plugin.LayerLegend = OpenLayers.Class(Legato.Control.Legend.Plugin,
//{
//  /*
//   * Function: initialize
//   *
//   * See Also:
//   * <Legato.Control.Legend.Plugin.initialize>
//   */
//  initialize : function(options) {
//    Legato.Control.Legend.Plugin.prototype.initialize.apply(this, arguments);
//  },
//
//  /*
//   * Function: destroy
//   * APIMethod: called if destroyed
//   *
//   * See Also:
//   * <Legato.Control.Legend.Plugin.destroy>
//   */
//  destroy : function() {
//    Legato.Control.Legend.Plugin.prototype.destroy.apply(this, arguments);
//  },
//
//  /*
//   * Function: drawControl
//   *
//   * See Also:
//   * <Legato.Control.Legend.Plugin.drawControl>
//   */
//  drawControl : function(div, layer) {
//    Legato.Control.Legend.Plugin.prototype.drawControl.apply(this, arguments);
//    return this.controlElement;
//  },
//
//  /*
//   * Function: createControlElement
//   *
//   * See Also:
//   * <Legato.Control.Legend.Plugin.createControlElement>
//   */
//  createControlElement: function(){
//    var controlElement = document.createElement('div');
//    controlElement.id  = this.getControlId();
//
//    /*
//     * Only WMS Layers are supported right now.
//     */
//    if(this.layer.CLASS_NAME == 'OpenLayers.Layer.WMS'){
//      /*
//      * Cause we're loading needed data asynchron we save all
//      * current controls in a hashmap for further processing.
//      */
//      this.getLegendUrl({
//        layer: this.layer,
//        control: controlElement,
//        onComplete: OpenLayers.Function.bind(this.onComplete, this)
//      });
//    }
//
//    return controlElement;
//  },
//
//  /*
//   * Gets for the given context the legend Url.
//   */
//  getLegendUrl: function(context){
//    Legato.Service.LayerCapabilities.prototype.getInstance().getLegendUrl(context);
//  },
//
//  /*
//   * Callback which is executed if the requested service has an answer
//   */
//  onComplete: function(context){
//    if(context.result === Legato.Service.BUSY){
//      OpenLayers.Console.debug('LayerCapabilities seems to be busy for ' + context.layer.url + '. Will try again in 1s');
//      OpenLayers.Element.addClass(context.control, 'LegatoControlLegendPluginLayerLegendLoading');
//      context.result = null;
//      setTimeout(OpenLayers.Function.bind(this.getLegendUrl, this), 1000, context);
//      return;
//    }
//
//    if(Legato.Lang.ObjectUtils.isNullOrUndefined(context.result.legendUrl) ||
//       Legato.Lang.ObjectUtils.isNullOrUndefined(context.result.legendUrl.href)){
//      OpenLayers.Console.debug('LayerCapabilities could not get legendUrl ' + context.layer.url);
//      OpenLayers.Element.removeClass(context.control, 'LegatoControlLegendPluginLayerLegendLoading');
//      OpenLayers.Element.addClass(context.control, 'LegatoControlLegendPluginLayerLegendNotDefined');
//      return;
//    }
//
//    var legendImg       = document.createElement('img');
//    legendImg.src       = context.result.legendUrl.href;
//
//    if(Legato.Lang.ObjectUtils.isNullOrUndefined(context.result.legendUrl.height)){
//      legendImg.height    = context.result.legendUrl.height;
//    }
//
//    if(Legato.Lang.ObjectUtils.isNullOrUndefined(context.result.legendUrl.width)){
//      legendImg.width    = context.result.legendUrl.width;
//    }
//
//    OpenLayers.Element.toggleClass(context.control, 'LegatoControlLegendPluginLayerLegendLoading');
//    context.control.appendChild(legendImg);
//    OpenLayers.Console.debug('LayerCapabilities loaded successfully wanted legendUrl');
//  },
//
//  /*
//   * Callback which is executed if the requested service caused an Failure
//   */
//  onFailure: function(request){
//    OpenLayers.Console.warn('Could not request');
//  },
//
//  /*
//   * Function: updateLayerValues
//   *
//   * See Also:
//   * <Legato.Control.Legend.Plugin.updateLayerValues>
//   */
//  updateLayerValues: function(controlElement){
//  },
//
//  /*
//   * Function: getControlId
//   *
//   * See Also:
//   * <Legato.Control.Legend.Plugin.getControlId>
//   */
//  getControlId: function(){
//    return this.layer.id +
//      this.idDelimiter +
//      this.id;
//  },
//
//  CLASS_NAME : 'Legato.Control.Legend.Plugin.LayerLegend'
//});
//
///**
// * Structure: lpp:LayerLegend
// * XML based config for <Legato.Control.Legend.Plugin.LayerLegend>.
// * If configured this control tries to determine the legendurl for each layer.
// * If the legendurl has been found an img will been rendered pointing to the
// * legendurl otherwise an empty div will been rendered instead.
// *
// * See Also:
// * - <Legato.Control.Legend.Plugin>
// * - <Legato.Beans.BeanFactory>
// * - <QName>
// *
// * A valid config example for a LayerLegend Plugin would be:
// * (start code)
// * <llp:LayerLegend />
// * (end)
// */
//Legato.Control.Legend.Plugin.LayerLegend.Bean = Legato.Control.Legend.Plugin.Bean.Extend(
//
//  'Legato.Control.Legend.Plugin.LayerLegend',
//
//  /*
//   * Property: QName
//   * The qualified name for this control. Needed by XML config to instantiate it.
//   */
//  Legato.Control.Legend.Plugin.QName('LayerLegend'),
//  {
//    _constructor: Legato.Control.Legend.Plugin.LayerLegend
//  }
//);
