/*
 * Decompiled with CFR 0.152.
 */
package net.distilledcode.aem.ui.touch.support.impl.ui;

import com.adobe.granite.ui.components.ExpressionHelper;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.distilledcode.aem.ui.touch.support.api.ui.DialogUtil;
import net.distilledcode.aem.ui.touch.support.api.ui.consoles.ConversionConfig;
import net.distilledcode.aem.ui.touch.support.spi.granite.ui.datasource.DataSourceFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;

@Component(service={DataSourceFactory.class}, property={"datasource.resourceTypes=distilledcode/aem-touch-ui-support/ui-components/console/datasource"})
public class ConsoleItemDataSource
extends DataSourceFactory {
    @Override
    @Nullable
    public Iterable<Resource> computeResources(@NotNull SlingHttpServletRequest request, @NotNull Resource dsResource, @NotNull ExpressionHelper ex) {
        ResourceResolver resolver = request.getResourceResolver();
        String configPath = ex.getString((String)dsResource.getValueMap().get("configPath", String.class));
        String[] searchRoots = Optional.ofNullable(configPath).map(arg_0 -> ((ResourceResolver)resolver).getResource(arg_0)).map(ConversionConfig::getScope).orElse(new String[0]);
        Comparator<@NotNull Resource> displayOrder = Comparator.comparing(DialogUtil::isClassicComponentDialog).reversed().thenComparing(Resource::getPath);
        return searchRoots.length == 0 ? null : ConsoleItemDataSource.getConvertibleResources(resolver, searchRoots).sorted(displayOrder)::iterator;
    }

    @NotNull
    public static Stream<Resource> getConvertibleResources(@NotNull ResourceResolver resolver, @NotNull String[] searchRoots) {
        Stream<String> dialogs = ConsoleItemDataSource.findResources(resolver, searchRoots, DialogUtil::isClassicDialog).filter(resource -> !Objects.equals(resource.getName(), "design_dialog")).filter(resource -> !Objects.equals(resource.getName(), "cq:dialog")).map(Resource::getPath);
        Stream<String> includes = ConsoleItemDataSource.findResources(resolver, searchRoots, DialogUtil.matchProperty("xtype", "cqinclude")).map(Resource::getValueMap).map(map -> (String)map.get("path", String.class)).filter(Objects::nonNull).map(path -> StringUtils.removeEnd((String)path, (String)".infinity.json")).filter(path -> StringUtils.startsWithAny((CharSequence)path, (CharSequence[])searchRoots)).distinct().map(arg_0 -> ((ResourceResolver)resolver).getResource(arg_0)).filter(Objects::nonNull).filter(DialogUtil::hasXtypeInDescendants).map(Resource::getPath);
        Set paths = Stream.concat(includes, dialogs).collect(Collectors.toCollection(LinkedHashSet::new));
        return paths.stream().filter(path -> paths.stream().noneMatch(ConsoleItemDataSource.isAncestorOf(path))).map(arg_0 -> ((ResourceResolver)resolver).getResource(arg_0)).filter(Objects::nonNull);
    }

    private static Predicate<? super String> isAncestorOf(String path) {
        return ancestor -> ancestor.length() < path.length() && path.startsWith((String)ancestor) && path.charAt(ancestor.length()) == '/';
    }

    private static Stream<Resource> findResources(@NotNull ResourceResolver resolver, @NotNull String[] searchRoots, @NotNull Predicate<Resource> filter) {
        Stream.Builder streamBuilder = Stream.builder();
        for (String searchRoot : searchRoots) {
            Resource root = resolver.getResource(searchRoot);
            if (root == null) continue;
            DialogUtil.findDescendants(root, filter).forEach(streamBuilder::add);
        }
        return streamBuilder.build();
    }
}

