/*
 * Decompiled with CFR 0.152.
 */
package net.distilledcode.aem.ui.touch.support.impl.ui;

import java.awt.Dimension;
import java.io.IOException;
import java.io.Writer;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonWriter;
import javax.servlet.Servlet;
import net.distilledcode.aem.ui.touch.support.impl.image.ImageReaderHelper;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.servlets.annotations.SlingServletResourceTypes;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;

@Component(service={Servlet.class})
@SlingServletResourceTypes(resourceTypes={"dam:Asset"}, selectors={"assetreference", "info"}, extensions={"json"})
public class AssetReferenceInfoServlet
extends SlingSafeMethodsServlet {
    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        ResourceResolver resolver = request.getResourceResolver();
        Resource assetResource = request.getResource();
        Resource renditions = assetResource.getChild("jcr:content/renditions");
        if (renditions == null) {
            response.sendError(404, "No renditions found for asset");
            return;
        }
        Resource original = renditions.getChild("original");
        if (original == null) {
            response.sendError(404, "No original rendition found for asset");
            return;
        }
        String mimeType = (String)original.getValueMap().get("jcr:content/jcr:mimeType", (Object)"");
        JsonObjectBuilder json = Json.createObjectBuilder().add("name", assetResource.getName()).add("url", this.getUrl(arg_0 -> ((ResourceResolver)resolver).map(arg_0), assetResource)).add("thumbnailUrl", this.getThummbnailUrl(arg_0 -> ((ResourceResolver)resolver).map(arg_0), assetResource)).add("mimeType", mimeType);
        AssetReferenceInfoServlet.getDimensions(original).ifPresent(dimension -> json.add("width", dimension.width).add("height", dimension.height));
        JsonArrayBuilder renditionsJson = Json.createArrayBuilder();
        boolean hasSeenWebRendition = false;
        for (Resource rendition : renditions.getChildren()) {
            boolean isClassicUiCropReference;
            String name = rendition.getName();
            if (Objects.equals(name, "original")) continue;
            boolean bl = isClassicUiCropReference = name.startsWith("cq5dam.web.") && !hasSeenWebRendition;
            if (isClassicUiCropReference) {
                hasSeenWebRendition = true;
            }
            AssetReferenceInfoServlet.getDimensions(rendition).ifPresent(dimensions -> {
                JsonObjectBuilder renditionJson = Json.createObjectBuilder().add("name", name).add("url", this.getUrl(arg_0 -> ((ResourceResolver)resolver).map(arg_0), rendition)).add("width", dimensions.width).add("height", dimensions.height);
                if (isClassicUiCropReference) {
                    renditionJson.add("isClassicUiCropReference", true);
                }
                renditionsJson.add(renditionJson);
            });
        }
        JsonObject jsonObject = json.add("renditions", renditionsJson).build();
        JsonWriter writer = Json.createWriterFactory(Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", true)).createWriter((Writer)response.getWriter());
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        writer.writeObject(jsonObject);
    }

    private String getUrl(Function<String, String> mapper, Resource rendition) {
        return mapper.apply(rendition.getPath()) + "?ch_ck=" + AssetReferenceInfoServlet.getLastModified(rendition);
    }

    private String getThummbnailUrl(Function<String, String> mapper, Resource rendition) {
        return mapper.apply(rendition.getPath()) + ".thumb.319.319.png?ch_ck=" + AssetReferenceInfoServlet.getLastModified(rendition);
    }

    private static String getExtension(String filename) {
        int lastDot = filename.lastIndexOf(46);
        return lastDot != -1 ? filename.substring(lastDot + 1) : null;
    }

    private static Optional<Dimension> getDimensions(Resource rendition) throws IOException {
        return ImageReaderHelper.from(() -> ImageReaderHelper.getRenditionInputStream(rendition)).withImageReader(ImageReaderHelper::getImageDimensions);
    }

    private static long getLastModified(@NotNull Resource rendition) {
        ValueMap properties = rendition.getValueMap();
        ZonedDateTime lastModified = Optional.ofNullable((Calendar)properties.get("jcr:content/jcr:lastModified", Calendar.class)).map(created -> created.toInstant().atZone(created.getTimeZone().toZoneId())).orElse(ZonedDateTime.now());
        return lastModified.toInstant().toEpochMilli();
    }
}

