/*
 * Decompiled with CFR 0.152.
 */
package net.distilledcode.aem.ui.touch.support.impl.foundation.form.tagfield;

import com.adobe.granite.ui.components.ExpressionHelper;
import com.day.cq.tagging.Tag;
import com.day.cq.tagging.TagManager;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.distilledcode.aem.ui.touch.support.spi.foundation.form.tagfield.TagNamespaceProvider;
import net.distilledcode.aem.ui.touch.support.spi.granite.ui.datasource.DataSourceFactory;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.util.Text;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={DataSourceFactory.class}, property={"datasource.resourceTypes=distilledcode/ui/components/coral/foundation/form/tagfield/datasources/tags", "datasource.resourceTypes=distilledcode/ui/components/coral/foundation/form/tagfield/datasources/search"})
public class TagFieldDataSourceFactory
extends DataSourceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(TagFieldDataSourceFactory.class);
    public static final String RT_CHILD_TAGS = "distilledcode/ui/components/coral/foundation/form/tagfield/datasources/tags";
    public static final String RT_TAG_SEARCH = "distilledcode/ui/components/coral/foundation/form/tagfield/datasources/search";
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private final List<TagNamespaceProvider> dynamicNamespaceProviders = new CopyOnWriteArrayList<TagNamespaceProvider>();
    private static final TagNamespaceProvider DEFAULT_TAG_NAMESPACE_PROVIDER = new DefaultTagNamespaceProvider();

    @Override
    @Nullable
    public Iterable<Resource> computeResources(@NotNull SlingHttpServletRequest request, @NotNull Resource dsResource, @NotNull ExpressionHelper ex) {
        boolean isChildTags = dsResource.isResourceType(RT_CHILD_TAGS);
        if (isChildTags || dsResource.isResourceType(RT_TAG_SEARCH)) {
            ValueMap dsProperties = dsResource.getValueMap();
            String path = ex.getString((String)dsProperties.get("path", String.class));
            if (StringUtils.isBlank((CharSequence)path)) {
                return null;
            }
            String configPath = ex.getString((String)dsProperties.get("configPath", String.class));
            ResourceResolver resolver = request.getResourceResolver();
            ValueMap config = Optional.ofNullable(configPath).map(arg_0 -> ((ResourceResolver)resolver).getResource(arg_0)).map(Resource::getValueMap).orElseGet(() -> ResourceUtil.getValueMap(null));
            Collection<String> namespaces = this.getAvailableNamespacesForPath(request, path, config);
            Stream<Resource> resourceStream = isChildTags ? TagFieldDataSourceFactory.computeChildTagResources(request, dsProperties, ex, namespaces) : TagFieldDataSourceFactory.computeTagSearchResources(request, dsProperties, ex, namespaces);
            int offset = (Integer)ex.get((String)dsProperties.get("offset", (Object)"0"), Integer.TYPE);
            int limit = (Integer)ex.get((String)dsProperties.get("limit", (Object)"20"), Integer.TYPE);
            return resourceStream.sorted(Comparator.comparing(Resource::getName)).skip(offset).limit(limit)::iterator;
        }
        throw new IllegalStateException("Called TagsDataSourceFactory for invalid resource type: " + dsResource.getResourceType());
    }

    @NotNull
    private static Stream<Resource> computeChildTagResources(SlingHttpServletRequest request, ValueMap dsProperties, ExpressionHelper ex, Collection<String> namespaces) {
        return Optional.ofNullable((TagManager)request.getResourceResolver().adaptTo(TagManager.class)).flatMap(tagManager -> Optional.ofNullable((String)dsProperties.get("tagId", String.class)).map(arg_0 -> ((ExpressionHelper)ex).getString(arg_0)).map(arg_0 -> ((TagManager)tagManager).resolve(arg_0))).map(tag -> TagFieldDataSourceFactory.computeChildTagResources(tag, namespaces)).orElseGet(Stream::empty);
    }

    @NotNull
    private static Stream<Resource> computeChildTagResources(Tag tag, Collection<String> namespaces) {
        Tag namespace;
        if (Objects.equals(tag.getPath(), "/etc/tags")) {
            return Optional.ofNullable((Resource)tag.adaptTo(Resource.class)).map(tagResource -> namespaces.stream().map(arg_0 -> ((Resource)tagResource).getChild(arg_0)).filter(Objects::nonNull).filter(child -> child.adaptTo(Tag.class) != null)).orElseGet(Stream::empty);
        }
        Tag tag2 = namespace = tag.isNamespace() ? tag : tag.getNamespace();
        if (namespaces.contains(namespace.getName())) {
            return Optional.of(() -> ((Tag)tag).listChildren()).map(childTags -> StreamSupport.stream(childTags.spliterator(), false).map(childTag -> (Resource)childTag.adaptTo(Resource.class)).filter(Objects::nonNull)).orElseGet(Stream::empty);
        }
        return Stream.empty();
    }

    @NotNull
    private static Stream<Resource> computeTagSearchResources(SlingHttpServletRequest request, ValueMap dsProperties, ExpressionHelper ex, Collection<String> namespaces) {
        return Optional.ofNullable((String)dsProperties.get("query", String.class)).map(arg_0 -> ((ExpressionHelper)ex).getString(arg_0)).filter(((Predicate<String>)StringUtils::isBlank).negate()).map(titleQuery -> TagFieldDataSourceFactory.createQuery(request.getLocale(), titleQuery, namespaces)).map(query -> () -> {
            LOG.debug("Executing xpath query '{}'", query);
            return request.getResourceResolver().findResources(query, "xpath");
        }).map(resources -> StreamSupport.stream(resources.spliterator(), false)).orElseGet(Stream::empty);
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private Collection<String> getAvailableNamespacesForPath(@NotNull SlingHttpServletRequest request, String path, ValueMap config) {
        boolean allowDynamicNamespaces = (Boolean)config.get("allowDynamicNamespaces", (Object)false);
        Stream dynamicProviders = allowDynamicNamespaces ? this.dynamicNamespaceProviders.stream() : Stream.empty();
        @NotNull Set allNamespaces = Stream.concat(Stream.of(DEFAULT_TAG_NAMESPACE_PROVIDER), dynamicProviders).map(provider -> {
            @NotNull String[] namespaces = provider.getNamespaces(request, path, config);
            LOG.debug("'{}' provides the following namespaces for '{}': {}", new Object[]{provider, path, namespaces});
            return namespaces;
        }).flatMap(Arrays::stream).collect(Collectors.toCollection(TreeSet::new));
        LOG.debug("Effective namespaces for '{}': {}", (Object)path, (Object)allNamespaces);
        return allNamespaces;
    }

    private static String createQuery(Locale locale, String query, Collection<String> namespaces) {
        String nsSegment = namespaces.stream().map(ISO9075::encode).collect(Collectors.joining("|", "/(", ")"));
        String localeCountry = ISO9075.encode((String)locale.toString().toLowerCase());
        String localeLanguage = ISO9075.encode((String)new Locale(locale.getLanguage()).toString().toLowerCase());
        String escapedQuery = Text.escapeIllegalXpathSearchChars((String)query).replaceAll("'", "''");
        String conditions = Stream.of("", localeCountry, localeLanguage).distinct().map(suffix -> "jcr:title" + (suffix.isEmpty() ? suffix : "." + suffix)).map(propertyName -> String.format("jcr:like(fn:lower-case(@%1$s), '%%%2$s%%')", propertyName, escapedQuery)).collect(Collectors.joining(" or ", "(", ")"));
        return String.format("/jcr:root/etc/tags%1$s//element(*, cq:Tag)[not(@cq:movedTo) and %2$s] order by @jcr:path", nsSegment, conditions);
    }

    private static class DefaultTagNamespaceProvider
    implements TagNamespaceProvider {
        private DefaultTagNamespaceProvider() {
        }

        @Override
        @NotNull
        public String[] getNamespaces(@NotNull SlingHttpServletRequest request, @NotNull String path, @NotNull ValueMap config) {
            String[] namespaces = (String[])config.get("namespaces", String[].class);
            if (namespaces == null && !((Boolean)config.get("allowDynamicNamespaces", (Object)false)).booleanValue()) {
                return (String[])Optional.ofNullable((TagManager)request.getResourceResolver().adaptTo(TagManager.class)).map(TagManager::getNamespaces).map(Arrays::stream).orElseGet(Stream::empty).map(Tag::getName).toArray(String[]::new);
            }
            return namespaces == null ? new String[]{} : namespaces;
        }

        public String toString() {
            return "DefaultTagNamespaceProvider";
        }
    }
}

