/*
 * Decompiled with CFR 0.152.
 */
package net.distilledcode.aem.ui.touch.support.impl.foundation;

import com.adobe.granite.ui.components.ExpressionHelper;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import com.day.cq.i18n.I18n;
import java.text.Collator;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.StreamSupport;
import javax.servlet.http.HttpServletRequest;
import net.distilledcode.aem.ui.touch.support.spi.granite.ui.datasource.DataSourceFactory;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;

@Component(service={DataSourceFactory.class}, property={"datasource.resourceTypes=distilledcode/cq/wcm/foundation/languages"})
public class LanguageOptionsDataSourceFactory
extends DataSourceFactory {
    private static final String LANGUAGE_PATH = "/mnt/overlay/wcm/core/resources/languages";

    @Override
    @Nullable
    public Iterable<Resource> computeResources(@NotNull SlingHttpServletRequest request, @NotNull Resource dsResource, @NotNull ExpressionHelper ex) {
        ResourceResolver resolver = request.getResourceResolver();
        Resource languageRoot = resolver.getResource(LANGUAGE_PATH);
        if (languageRoot == null) {
            return null;
        }
        I18n i18n = new I18n((HttpServletRequest)request);
        Collator collator = Collator.getInstance(request.getLocale());
        collator.setStrength(0);
        return () -> StreamSupport.stream(languageRoot.getChildren().spliterator(), false).map(LanguageOptionsDataSourceFactory.toOptionResource(resolver, i18n)).filter(Objects::nonNull).sorted(Comparator.comparing(res -> res.getValueMap().get((Object)"text"), collator)).iterator();
    }

    private static Function<Resource, Resource> toOptionResource(ResourceResolver resolver, I18n i18n) {
        return resource -> {
            ValueMap properties = resource.getValueMap();
            ValueMapDecorator props = new ValueMapDecorator(new HashMap());
            String language = (String)properties.get("language", String.class);
            if (language == null) {
                return null;
            }
            String country = (String)properties.get("country", (Object)"*");
            String label = language + (Objects.equals(country, "*") ? "" : " (" + country + ")");
            props.put("text", (Object)i18n.get(label));
            props.put("value", (Object)resource.getName());
            return new ValueMapResource(resolver, "", null, (ValueMap)props);
        };
    }
}

