/*
 * Decompiled with CFR 0.152.
 */
package net.distilledcode.aem.ui.touch.support.api.ui.granite;

import com.adobe.granite.ui.components.ExpressionHelper;
import com.adobe.granite.ui.components.ExpressionResolver;
import com.adobe.granite.ui.components.ds.DataSource;
import com.day.cq.wcm.api.WCMMode;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.api.scripting.SlingScriptHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CoralUtil {
    @NotNull
    public static Iterable<Resource> getItemDataSource(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @NotNull Resource resource) {
        return Optional.ofNullable(resource.getChild("items")).map(Resource::getChildren).orElseGet(() -> CoralUtil.getDataSource(request, response, resource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private static Iterable<Resource> getDataSource(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response, @NotNull Resource resource) {
        block7: {
            Resource datasource = resource.getChild("datasource");
            if (datasource != null) {
                try {
                    RequestDispatcher requestDispatcher = request.getRequestDispatcher(datasource);
                    if (requestDispatcher == null) break block7;
                    WCMMode originalWcmMode = WCMMode.DISABLED.toRequest((ServletRequest)request);
                    try {
                        requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
                    }
                    finally {
                        originalWcmMode.toRequest((ServletRequest)request);
                    }
                    DataSource ds = (DataSource)request.getAttribute(DataSource.class.getName());
                    if (ds != null) {
                        request.removeAttribute(DataSource.class.getName());
                        return () -> {
                            Iterator iterator = ds.iterator();
                            return iterator != null ? iterator : Stream.empty().iterator();
                        };
                    }
                }
                catch (IOException | ServletException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return Stream.empty()::iterator;
    }

    @Nullable
    public static ExpressionHelper getExpressionHelper(@NotNull SlingHttpServletRequest request) {
        ExpressionResolver expressionResolver;
        SlingScriptHelper sling;
        SlingBindings slingBindings = (SlingBindings)request.getAttribute(SlingBindings.class.getName());
        if (slingBindings != null && (sling = slingBindings.getSling()) != null && (expressionResolver = (ExpressionResolver)sling.getService(ExpressionResolver.class)) != null) {
            return new ExpressionHelper(expressionResolver, request);
        }
        return null;
    }

    public static BiFunction<String, Object, String> addClasses(String ... cssClasses) {
        return (key, value) -> {
            if (!Objects.equals("class", key)) {
                throw new IllegalArgumentException("\"addClasses\" only handles the \"class\" key");
            }
            Stream oldClasses = Optional.ofNullable(value).filter(v -> v instanceof String).map(Object::toString).map(StringUtils::split).map(Stream::of).orElseGet(Stream::empty);
            Stream<String> newClasses = Stream.of(cssClasses).filter(StringUtils::isNotBlank).map(StringUtils::strip);
            return Stream.concat(oldClasses, newClasses).distinct().collect(Collectors.joining(" "));
        };
    }

    public static BiFunction<String, Object, Object> putNullSafe(@Nullable Object value) {
        return (key, oldValue) -> value;
    }

    public static Map<String, Object> getGraniteCommonAttributes(@NotNull Resource resource, @Nullable ExpressionHelper expressionHelper) {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        ValueMap properties = resource.getValueMap();
        CoralUtil.safeAddToMap(attributes, "id", properties.get("granite:id", String.class));
        CoralUtil.safeAddToMap(attributes, "rel", properties.get("granite:rel", String.class));
        CoralUtil.safeAddToMap(attributes, "class", properties.get("granite:class", String.class));
        CoralUtil.safeAddToMap(attributes, "title", properties.get("granite:title", String.class));
        CoralUtil.safeAddToMap(attributes, "hidden", properties.get("granite:hidden", (Object)false));
        CoralUtil.safeAddToMap(attributes, "itemscope", properties.get("granite:itemscope", String.class));
        CoralUtil.safeAddToMap(attributes, "itemtype", properties.get("granite:itemtype", String.class));
        CoralUtil.safeAddToMap(attributes, "itemprop", properties.get("granite:itemitemprop", String.class));
        Resource graniteData = resource.getChild("granite:data");
        if (graniteData != null) {
            CoralUtil.addGraniteDataAttributes(attributes, graniteData.getValueMap(), expressionHelper);
        }
        return attributes;
    }

    private static void addGraniteDataAttributes(@NotNull Map<String, Object> attributes, @NotNull ValueMap dataProperties, @Nullable ExpressionHelper expressionHelper) {
        dataProperties.keySet().stream().filter(key -> !key.contains(":")).forEach(key -> {
            String value;
            String expression = (String)dataProperties.get(key, String.class);
            String string = value = expressionHelper == null ? expression : expressionHelper.getString(expression);
            if (value != null) {
                attributes.put("data-" + key, value);
            }
        });
    }

    private static void safeAddToMap(Map<String, Object> attributes, String key, Object value) {
        if (value != null) {
            attributes.put(key, value);
        }
    }

    private CoralUtil() {
    }
}

