/*
 * Decompiled with CFR 0.152.
 */
package net.distilledcode.aem.ui.touch.support.api.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuickActions
implements Iterable<Link> {
    private final List<Link> quickActions = new ArrayList<Link>();

    public void add(@NotNull String rel, @Nullable String href) {
        this.quickActions.add(new Link(rel, href));
    }

    public String getActivators() {
        return this.quickActions.stream().map(rec$ -> ((Link)rec$).getActivator()).collect(Collectors.joining(" "));
    }

    @Override
    @NotNull
    public Iterator<Link> iterator() {
        return this.quickActions.stream().filter(link -> link.href != null).iterator();
    }

    public static class Link {
        public final String rel;
        public final String href;

        public Link(@NotNull String rel, @Nullable String href) {
            this.rel = rel;
            this.href = href;
        }

        private String getActivator() {
            return this.rel + "-activator";
        }
    }
}

