/*
 * Decompiled with CFR 0.152.
 */
package net.distilledcode.aem.ui.touch.support.api.ui;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import net.distilledcode.aem.ui.touch.support.impl.ui.Templates;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DialogUtil {
    public static final String COMPARISON_PATH_PREFIX = "/apps/distilledcode/aem-touch-ui-support/ui/comparison";
    public static final String CLASSIC_DIALOG_PATH_PREFIX = "/apps/distilledcode/aem-touch-ui-support/ui/comparison/_jcr_content/content/items/comparison.classic-ui-dialog.html";

    public static String getTouchUiName(Resource resource) {
        if (DialogUtil.isClassicComponentDialog(resource)) {
            return "cq:dialog";
        }
        if (DialogUtil.isClassicDialog(resource) || !DialogUtil.isWithinClassicDialog(resource)) {
            return "touch-ui-include-" + resource.getName();
        }
        return resource.getName();
    }

    public static String getTouchUiPath(Resource resource) {
        String parentPath = ResourceUtil.getParent((String)resource.getPath());
        return parentPath + "/" + DialogUtil.getTouchUiName(resource);
    }

    public static Resource findTouchUiResource(Resource classicResource) {
        String touchUiPath;
        Resource touchUiIncludeRoot;
        String touchUiPath2;
        Resource touchDialog;
        ResourceResolver resolver = classicResource.getResourceResolver();
        Resource classicDialog = DialogUtil.findContainingDialog(classicResource);
        if (classicDialog != null && (touchDialog = resolver.getResource(touchUiPath2 = DialogUtil.getTouchUiPath(classicDialog))) != null) {
            return DialogUtil.getCorrespondingTouchUiResource(classicResource, classicDialog, touchDialog);
        }
        Resource includeRoot = DialogUtil.findContainingIncludeRoot(classicResource);
        if (includeRoot != null && includeRoot.getParent() != null && (touchUiIncludeRoot = resolver.getResource(touchUiPath = DialogUtil.getTouchUiPath(includeRoot))) != null) {
            return DialogUtil.getCorrespondingTouchUiResource(classicResource, includeRoot, touchUiIncludeRoot);
        }
        return classicResource;
    }

    private static Resource getCorrespondingTouchUiResource(Resource classicResource, Resource classicRoot, Resource touchRoot) {
        if (Objects.equals(classicResource.getPath(), classicRoot.getPath())) {
            return touchRoot;
        }
        String suffix = StringUtils.removeStart((String)classicResource.getPath(), (String)classicRoot.getPath());
        String name = ResourceUtil.getName((String)suffix);
        List<Resource> descendants = DialogUtil.findDescendants(touchRoot, resource -> Objects.equals(resource.getName(), name));
        Comparator<Resource> comparing = Comparator.comparing(resource -> {
            String touchSuffix = StringUtils.removeStart((String)resource.getPath(), (String)touchRoot.getPath());
            return StringUtils.getLevenshteinDistance((CharSequence)touchSuffix, (CharSequence)suffix);
        });
        descendants.sort(comparing);
        if (descendants.isEmpty()) {
            throw new IllegalStateException("No descendant named '" + name + "' found in '" + touchRoot.getPath() + "'");
        }
        return descendants.get(0);
    }

    @Nullable
    private static Resource findContainingIncludeRoot(Resource classicResource) {
        return DialogUtil.findMatchingAncestor(classicResource, DialogUtil::hasTouchUiIncludeSibling);
    }

    private static boolean hasTouchUiIncludeSibling(Resource resource) {
        String touchUiName = DialogUtil.getTouchUiName(resource);
        Resource parent = resource.getParent();
        if (parent != null) {
            return parent.getChild(touchUiName) != null;
        }
        return false;
    }

    public static boolean hasXtypeInDescendants(Resource classicDialogResource) {
        return !DialogUtil.findDescendants(classicDialogResource, res -> {
            ValueMap properties = res.getValueMap();
            return properties.containsKey((Object)"xtype") || Objects.equals(properties.get("jcr:primaryType", String.class), "cq:Widget");
        }).isEmpty();
    }

    public static List<Resource> findDescendants(Resource resource, Predicate<Resource> filter) {
        ArrayList<Resource> matchingDescendants = new ArrayList<Resource>();
        for (Resource child : resource.getChildren()) {
            if (filter.test(child)) {
                matchingDescendants.add(child);
            }
            matchingDescendants.addAll(DialogUtil.findDescendants(child, filter));
        }
        return matchingDescendants;
    }

    @Nullable
    @Contract(value="null,_->null")
    private static Resource findMatchingAncestor(Resource resource, Predicate<Resource> toFind) {
        Resource candidate;
        for (candidate = resource; candidate != null && !toFind.test(candidate); candidate = candidate.getParent()) {
        }
        return candidate;
    }

    @Contract(value="null->null")
    public static Resource findContainingDialog(Resource classicDialogResource) {
        return DialogUtil.findMatchingAncestor(classicDialogResource, DialogUtil::isClassicDialog);
    }

    @Contract(value="null->false")
    public static boolean isClassicDialog(Resource resource) {
        return DialogUtil.matchProperty("jcr:primaryType", "cq:Dialog").test(resource);
    }

    @NotNull
    public static Predicate<Resource> matchProperty(String propertyName, Object value) {
        return resource -> resource != null && Objects.equals(resource.getValueMap().get(propertyName, value.getClass()), value);
    }

    public static boolean isClassicComponentDialog(@NotNull Resource resource) {
        return Objects.equals(resource.getName(), "dialog") && DialogUtil.isClassicDialog(resource) && DialogUtil.isComponent(resource.getParent());
    }

    @Contract(value="null->false")
    public static boolean isComponent(@Nullable Resource resource) {
        return DialogUtil.matchProperty("jcr:primaryType", "cq:Component").test(resource);
    }

    @Contract(value="null->false")
    public static boolean isWithinClassicDialog(Resource resource) {
        return DialogUtil.findContainingDialog(resource) != null;
    }

    @Contract(value="null->false")
    public static boolean isPageRenderingComponent(@Nullable Resource componentResource) {
        if (DialogUtil.isComponent(componentResource)) {
            Resource candidate = componentResource;
            while (candidate != null) {
                Templates templates = (Templates)candidate.adaptTo(Templates.class);
                if (templates != null && !templates.isEmpty() || candidate.getChild("cq:infoProviders") != null) {
                    return true;
                }
                candidate = DialogUtil.loadSuperTypeResource(candidate);
            }
        }
        return false;
    }

    @Nullable
    private static Resource loadSuperTypeResource(@NotNull Resource component) {
        String resourceSuperType = component.getResourceSuperType();
        return resourceSuperType == null ? null : component.getResourceResolver().getResource(resourceSuperType);
    }

    public static String getTouchUiDialogUrl(String componentPath) {
        return "/mnt/override" + componentPath + "/_cq_dialog.html?page=true";
    }

    public static String getClassicUiDialogUrl(String componentPath) {
        return CLASSIC_DIALOG_PATH_PREFIX + componentPath;
    }
}

