/*
 * Decompiled with CFR 0.152.
 */
package net.distilledcode.aem.ui.touch.support.impl.ui;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import net.distilledcode.aem.ui.touch.support.impl.ui.Templates;
import org.apache.sling.api.adapter.AdapterFactory;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;

@Component(service={AdapterFactory.class}, property={"adaptables=org.apache.sling.api.resource.Resource", "adaptables=org.apache.sling.api.resource.ResourceResolver", "adapters=net.distilledcode.aem.ui.touch.support.impl.ui.Templates", "adapters=net.distilledcode.aem.ui.touch.support.impl.ui.TemplateInfoAdapterFactory"})
public class TemplateInfoAdapterFactory
implements AdapterFactory {
    private final Map<ResourceResolver, Map<String, Set<String>>> cache = new WeakHashMap<ResourceResolver, Map<String, Set<String>>>();

    public <AdapterType> AdapterType getAdapter(@NotNull Object adaptable, @NotNull Class<AdapterType> type) {
        if (adaptable instanceof Resource && type == Templates.class) {
            Resource resource = (Resource)adaptable;
            return (AdapterType)new Templates(this.getTemplates(resource));
        }
        return null;
    }

    @NotNull
    private Collection<? extends String> getTemplates(@NotNull Resource resource) {
        ResourceResolver resolver = resource.getResourceResolver();
        Map resourceTypeToTemplates = this.cache.computeIfAbsent(resolver, TemplateInfoAdapterFactory::createTemplateMap);
        String path = resource.getPath();
        String resourceType = TemplateInfoAdapterFactory.toResourceType(resolver.getSearchPath(), path);
        return resourceTypeToTemplates.getOrDefault(resourceType, Collections.emptySet());
    }

    private static Map<String, Set<String>> createTemplateMap(ResourceResolver resolver) {
        Iterable templateResources = () -> resolver.findResources("/jcr:root//element(*, cq:Template)/jcr:content", "xpath");
        HashMap<String, Set<String>> templateMap = new HashMap<String, Set<String>>();
        for (Resource template : templateResources) {
            ValueMap properties = template.getValueMap();
            String resourceType = TemplateInfoAdapterFactory.toResourceType(resolver.getSearchPath(), (String)properties.get("sling:resourceType", String.class));
            String path = ResourceUtil.getParent((String)template.getPath());
            if (resourceType == null) continue;
            Set templatePaths = templateMap.computeIfAbsent(resourceType, key -> new HashSet());
            templatePaths.add(path);
        }
        return TemplateInfoAdapterFactory.makeImmutableCopy(templateMap);
    }

    private static Map<String, Set<String>> makeImmutableCopy(Map<String, Set<String>> templateMap) {
        HashMap copy = new HashMap();
        for (String key : templateMap.keySet()) {
            copy.put(key, Collections.unmodifiableSet(new HashSet(templateMap.get(key))));
        }
        return Collections.unmodifiableMap(copy);
    }

    @Nullable
    private static String toResourceType(@NotNull String[] searchPath, @Nullable String path) {
        if (path == null) {
            return null;
        }
        String resourceType = path;
        for (String prefix : searchPath) {
            if (!path.startsWith(prefix)) continue;
            resourceType = path.substring(prefix.length());
            break;
        }
        return resourceType;
    }
}

