/*
 * Decompiled with CFR 0.152.
 */
package net.distilledcode.aem.ui.touch.support.impl.foundation.form.tagfield;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.distilledcode.aem.ui.touch.support.spi.foundation.form.tagfield.TagNamespaceProvider;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.metatype.annotations.AttributeDefinition;
import org.osgi.service.metatype.annotations.Designate;
import org.osgi.service.metatype.annotations.ObjectClassDefinition;

@Component(service={TagNamespaceProvider.class}, configurationPolicy=ConfigurationPolicy.REQUIRE)
@Designate(ocd=Config.class)
public class PathBasedTagNamespaceProvider
implements TagNamespaceProvider {
    private List<Mapping> mappings;

    @Activate
    @Modified
    public void activate(Config config) {
        String[] mappings = Optional.ofNullable(config.namespace_mappings()).orElse(new String[0]);
        this.mappings = Arrays.stream(mappings).map(Mapping::create).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    @Deactivate
    public void deactivate() {
        this.mappings = null;
    }

    @Override
    @NotNull
    public String[] getNamespaces(@NotNull SlingHttpServletRequest request, @NotNull String path, @NotNull ValueMap config) {
        TreeSet<String> namespaces = new TreeSet<String>();
        for (Mapping mapping : this.mappings) {
            Matcher matcher = mapping.getRegexp().matcher(path);
            if (!matcher.matches()) continue;
            for (String namespace : mapping.getNamespaces()) {
                namespaces.add(matcher.replaceAll(namespace));
            }
        }
        return namespaces.toArray(new String[0]);
    }

    private static class Mapping {
        private final Pattern regexp;
        private final String[] namespaces;

        public static Mapping create(String config) {
            String[] parts = config.split(" :: ");
            if (parts.length != 2) {
                throw new IllegalArgumentException("Invalid configuration \"" + config + "\"");
            }
            Pattern regexp = Pattern.compile(parts[0].trim());
            String[] namespaces = parts[1].split(",");
            return new Mapping(regexp, (String[])Arrays.stream(namespaces).map(String::trim).toArray(String[]::new));
        }

        private Mapping(Pattern regexp, String[] namespaces) {
            this.regexp = regexp;
            this.namespaces = namespaces;
        }

        public Pattern getRegexp() {
            return this.regexp;
        }

        public String[] getNamespaces() {
            return this.namespaces;
        }
    }

    @ObjectClassDefinition(name="Distilled Code ~ Path Based Tag Namespace Provider")
    static @interface Config {
        @AttributeDefinition(description="Regular expression followed by \" :: \" (space, 2x colon, space) followed by a comma separated list of namespaces (may refer to regexp groups). E.g \"/content/([^/]+).* :: generic,$1\"")
        public String[] namespace_mappings() default {};
    }
}

