/*
 * Decompiled with CFR 0.152.
 */
package net.distilledcode.aem.ui.touch.support.impl.fixes;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.sling.api.resource.ValueMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MergingValueMap
implements ValueMap {
    private static final String IMMUTABLE_ERROR_MESSAGE = "MergingValueMap is immutable";
    private final List<ValueMap> valueMaps;

    public MergingValueMap(@NotNull List<ValueMap> valueMaps) {
        this.valueMaps = Collections.unmodifiableList(new ArrayList<ValueMap>(valueMaps));
    }

    @Nullable
    public <T> T get(@NotNull String name, @NotNull Class<T> type) {
        Object value = this.get(name);
        if (value == null) {
            return null;
        }
        if (type.isAssignableFrom(value.getClass())) {
            return (T)value;
        }
        return null;
    }

    @NotNull
    public <T> T get(@NotNull String name, @NotNull T defaultValue) {
        if (defaultValue == null) {
            throw new NullPointerException("defaultValue must not be null");
        }
        Class<?> value = this.get(name, (T)defaultValue.getClass());
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    public int size() {
        return this.keySet().size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean containsKey(Object key) {
        return this.keyStream().anyMatch(k -> Objects.equals(k, key));
    }

    public boolean containsValue(Object value) {
        return this.valueStream().anyMatch(v -> Objects.equals(v, value));
    }

    public Object get(Object key) {
        return this.valueMaps.stream().filter(vm -> vm.containsKey(key)).findFirst().map(vm -> vm.get(key)).orElse(null);
    }

    @NotNull
    public Set<String> keySet() {
        return this.keyStream().collect(Collectors.toSet());
    }

    @NotNull
    public Collection<Object> values() {
        return this.valueStream().collect(Collectors.toList());
    }

    @NotNull
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.keyStream().map(key -> new AbstractMap.SimpleEntry<String, Object>((String)key, this.get(key))).collect(Collectors.toSet());
    }

    @NotNull
    private Stream<String> keyStream() {
        return this.valueMaps.stream().map(Map::keySet).flatMap(Collection::stream).distinct();
    }

    @NotNull
    private Stream<Object> valueStream() {
        return this.keyStream().map(this::get);
    }

    public Object put(String aKey, Object value) {
        throw new UnsupportedOperationException(IMMUTABLE_ERROR_MESSAGE);
    }

    public Object remove(Object key) {
        throw new UnsupportedOperationException(IMMUTABLE_ERROR_MESSAGE);
    }

    public void putAll(@NotNull Map<? extends String, ?> properties) {
        throw new UnsupportedOperationException(IMMUTABLE_ERROR_MESSAGE);
    }

    public void clear() {
        throw new UnsupportedOperationException(IMMUTABLE_ERROR_MESSAGE);
    }
}

