/*
 * Decompiled with CFR 0.152.
 */
package net.distilledcode.aem.ui.touch.support.api.ui.granite;

import com.day.cq.tagging.TagManager;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import net.distilledcode.aem.ui.touch.support.api.ui.granite.CoralUtil;
import net.distilledcode.aem.ui.touch.support.api.ui.granite.Field;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.models.annotations.Model;
import org.jetbrains.annotations.NotNull;

@Model(resourceType={"distilledcode/aem-touch-ui-support/components/tagfield"}, adaptables={SlingHttpServletRequest.class}, adapters={Field.class, TagField.class})
public class TagField
extends Field<String[]> {
    private final Locale locale;
    private final TagManager tagManager;

    @Inject
    public TagField(SlingHttpServletRequest request) {
        super(request);
        this.locale = request.getLocale();
        this.tagManager = (TagManager)request.getResourceResolver().adaptTo(TagManager.class);
    }

    @Override
    @NotNull
    protected String[] getDefaultValue() {
        return new String[0];
    }

    @Override
    public Map<String, Object> getAttributes() {
        Map<String, Object> attributes = super.getAttributes();
        attributes.compute("class", CoralUtil.addClasses("cq-ui-tagfield"));
        attributes.compute("placeholder", CoralUtil.putNullSafe(this.properties.get("emptyText", String.class)));
        String defaultPickerSrc = "/apps/distilledcode/aem-touch-ui-support/content/tagfield/picker.html${param.item != null ? param.item : requestPathInfo.suffix}?_charset_=utf-8&selectionCount=multiple&configPath=" + this.resource.getPath();
        String pickerSrc = (String)this.properties.get("pickerSrc", (Object)defaultPickerSrc);
        attributes.compute("pickersrc", CoralUtil.putNullSafe(Optional.ofNullable(this.expressionHelper).map(ex -> ex.getString(pickerSrc)).orElse(pickerSrc)));
        attributes.put("required", this.properties.get("required", (Object)false));
        attributes.put("disabled", this.properties.get("disabled", (Object)false));
        attributes.put("forceselection", this.properties.get("forceSelection", (Object)false));
        boolean isMultiple = (Boolean)this.properties.get("multiple", (Object)false);
        attributes.put("multiple", isMultiple);
        if (isMultiple) {
            attributes.put("valuedisplaymode", "block");
        }
        if (((Boolean)this.properties.get("autocreateTag", (Object)false)).booleanValue()) {
            attributes.put("data-cq-ui-tagfield-create-action", this.resource.getPath());
        }
        return attributes;
    }

    public Map<String, Object> getSuggestAttributes() {
        LinkedHashMap<String, Object> suggestAttributes = new LinkedHashMap<String, Object>();
        String defaultSuggestSrc = "/apps/distilledcode/aem-touch-ui-support/content/tagfield/suggestions{.offset,limit}.html${param.item != null ? param.item : requestPathInfo.suffix}?_charset_=utf-8&configPath=" + this.resource.getPath() + "{&query}";
        String suggestSrc = (String)this.properties.get("suggestSrc", (Object)defaultSuggestSrc);
        suggestAttributes.put("foundation-autocomplete-suggestion", true);
        suggestAttributes.compute("class", CoralUtil.addClasses("foundation-picker-buttonlist"));
        suggestAttributes.compute("data-foundation-picker-buttonlist-src", CoralUtil.putNullSafe(Optional.ofNullable(this.expressionHelper).map(ex -> ex.getString(suggestSrc)).orElse(suggestSrc)));
        return suggestAttributes;
    }

    public Map<String, Object> getValueAttributes() {
        LinkedHashMap<String, Object> valueAttributes = new LinkedHashMap<String, Object>();
        valueAttributes.put("foundation-autocomplete-value", true);
        valueAttributes.put("name", this.getName());
        return valueAttributes;
    }

    public Set<Tag> getTags() {
        return this.getStoredValue().map(Arrays::stream).orElseGet(Stream::empty).map(this::toTag).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private Tag toTag(String tagId) {
        com.day.cq.tagging.Tag cqTag = this.tagManager.resolve(tagId);
        return new Tag(cqTag.getTitlePath(this.locale), tagId);
    }

    public static class Tag {
        private final String title;
        private final String value;

        Tag(String title, String value) {
            this.title = title;
            this.value = value;
        }

        public String getTitle() {
            return this.title;
        }

        public String getValue() {
            return this.value;
        }
    }
}

