/*
 * Decompiled with CFR 0.152.
 */
package net.distilledcode.aem.ui.touch.support.api.ui.granite;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import net.distilledcode.aem.ui.touch.support.api.ui.granite.CoralUtil;
import net.distilledcode.aem.ui.touch.support.api.ui.granite.Field;
import net.distilledcode.aem.ui.touch.support.api.ui.granite.GenericStringField;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Model;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@Model(resourceType={"distilledcode/aem-touch-ui-support/components/colorfield"}, adaptables={SlingHttpServletRequest.class}, adapters={Field.class, ColorField.class})
@ProviderType
public class ColorField
extends GenericStringField {
    private final Type type;
    private final Supplier<List<ColorDefinition>> colorDefinitions;

    @Inject
    public ColorField(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) {
        super(request);
        this.type = Type.fromString((String)this.properties.get("type", (Object)"picker"));
        this.colorDefinitions = () -> Optional.of(CoralUtil.getItemDataSource(request, response, this.resource)).map(resources -> StreamSupport.stream(resources.spliterator(), false)).orElseGet(Stream::empty).map(ColorDefinition::create).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Override
    public Map<String, Object> getAttributes() {
        Map<String, Object> attributes = super.getAttributes();
        Predicate<String> isOff = val -> Objects.equals(val, "off");
        this.copyPropertyIf(attributes, "showdefaultcolors", "on", isOff);
        this.copyPropertyIf(attributes, "showproperties", "on", isOff);
        attributes.compute("class", CoralUtil.addClasses("distilledcode-colorfield"));
        return attributes;
    }

    private <T> void copyPropertyIf(Map<String, Object> attributes, String name, T defaultValue, Predicate<T> predicate) {
        Object value = this.properties.get(name, defaultValue);
        if (predicate.test(value)) {
            attributes.put(name, value);
        }
    }

    public String getTagName() {
        return this.type.getTagName();
    }

    public List<ColorDefinition> getColorDefinitions() {
        return this.colorDefinitions.get();
    }

    public String toString() {
        return "ColorField{type=" + (Object)((Object)this.type) + ", colorDefinitions=" + this.colorDefinitions + '}';
    }

    private static enum Type {
        PICKER("coral-colorinput", "color-colorinput-item"),
        DROPDOWN("coral-select", "color-select-item");

        private final String htmlTagName;
        private final String itemTagName;

        static Type fromString(String type) {
            return Stream.of(Type.values()).filter(v -> v.name().equalsIgnoreCase(type)).findFirst().orElse(PICKER);
        }

        private Type(String tagName, String itemTagName) {
            this.htmlTagName = tagName;
            this.itemTagName = itemTagName;
        }

        public String getTagName() {
            return this.htmlTagName;
        }

        public String getItemTagName() {
            return this.itemTagName;
        }

        public String toString() {
            return "Type{name='" + this.name() + '\'' + ", htmlTagName='" + this.htmlTagName + '\'' + ", itemTagName='" + this.itemTagName + '\'' + '}';
        }
    }

    public static class ColorDefinition {
        private final String label;
        private final String colorValue;

        ColorDefinition(String label, String colorValue) {
            this.label = label;
            this.colorValue = colorValue;
        }

        public String getLabel() {
            return this.label;
        }

        public String getColorValue() {
            return this.colorValue;
        }

        public static ColorDefinition create(Resource resource) {
            ValueMap props = resource.getValueMap();
            String label = (String)props.get("label", (Object)resource.getName());
            String color = (String)props.get("colorValue", String.class);
            return color != null ? new ColorDefinition(label, color) : null;
        }

        public String toString() {
            return "ColorDefinition{label='" + this.label + '\'' + ", colorValue='" + this.colorValue + '\'' + '}';
        }
    }
}

