/*
 * Decompiled with CFR 0.152.
 */
package net.distilledcode.aem.ui.touch.support.api.ui.granite;

import com.adobe.granite.ui.components.ExpressionHelper;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import net.distilledcode.aem.ui.touch.support.api.ui.granite.CoralUtil;
import net.distilledcode.aem.ui.touch.support.api.ui.granite.Field;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Model;
import org.jetbrains.annotations.NotNull;

@Model(resourceType={"distilledcode/aem-touch-ui-support/components/checkboxgroup"}, adaptables={SlingHttpServletRequest.class}, adapters={Field.class, CheckboxGroup.class})
public class CheckboxGroup
extends Field<String[]> {
    private final SlingHttpServletRequest request;
    private final SlingHttpServletResponse response;
    private final List<Checkbox> checkboxes;

    @Inject
    public CheckboxGroup(SlingHttpServletRequest request, SlingHttpServletResponse response) {
        super(request);
        this.request = request;
        this.response = response;
        this.checkboxes = this.getCheckboxStream().collect(Collectors.toList());
    }

    @Override
    public Map<String, Object> getAttributes() {
        Map<String, Object> attributes = super.getAttributes();
        attributes.compute("class", CoralUtil.addClasses("distilledcode-checkbox-group"));
        attributes.remove("name");
        String requiredMsg = (String)this.properties.get("requiredMsg", String.class);
        if (requiredMsg != null) {
            attributes.put("data-required-msg", requiredMsg);
        }
        return attributes;
    }

    @Override
    @NotNull
    protected String[] getDefaultValue() {
        return (String[])this.checkboxes.stream().filter(Checkbox::isCheckedByDefault).map(Checkbox::getValue).toArray(String[]::new);
    }

    public Iterable<Checkbox> getCheckboxes() {
        return this.checkboxes;
    }

    @NotNull
    private Stream<Checkbox> getCheckboxStream() {
        return Optional.of(CoralUtil.getItemDataSource(this.request, this.response, this.resource)).map(resources -> StreamSupport.stream(resources.spliterator(), false)).orElseGet(Stream::empty).map(this::itemToCheckbox);
    }

    private Checkbox itemToCheckbox(Resource resource) {
        return new Checkbox(this, resource);
    }

    public static class Checkbox {
        private final CheckboxGroup checkboxGroup;
        private final Resource resource;
        private final ValueMap properties;

        Checkbox(CheckboxGroup checkboxGroup, Resource resource) {
            this.checkboxGroup = checkboxGroup;
            this.resource = resource;
            this.properties = resource.getValueMap();
        }

        public String getLabel() {
            String text = (String)this.properties.get("text", String.class);
            boolean translateOptions = (Boolean)this.properties.get("translateOptions", (Object)true);
            return translateOptions ? this.checkboxGroup.i18n.getVar(text) : text;
        }

        public String getValue() {
            return (String)this.properties.get("value", String.class);
        }

        public Map<String, Object> getAttributes() {
            String checkboxValue = this.getValue();
            ExpressionHelper eh = this.checkboxGroup.expressionHelper;
            Map<String, Object> attributes = CoralUtil.getGraniteCommonAttributes(this.resource, eh);
            attributes.put("name", this.checkboxGroup.getName());
            attributes.put("value", checkboxValue);
            attributes.put("checked", this.isChecked());
            attributes.put("disabled", this.checkboxGroup.isDisabled());
            return attributes;
        }

        public boolean isChecked() {
            Object[] storedValue = this.checkboxGroup.getStoredValue().orElse(this.checkboxGroup.getDefaultValue());
            return ArrayUtils.contains((Object[])storedValue, (Object)this.getValue());
        }

        public boolean isCheckedByDefault() {
            return (Boolean)this.properties.get("checked", (Object)false);
        }
    }
}

