/*
 * Decompiled with CFR 0.152.
 */
package net.distilledcode.aem.ui.touch.support.api.ui.consoles;

import com.day.cq.wcm.api.PageManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import net.distilledcode.aem.ui.touch.support.api.ui.DialogUtil;
import net.distilledcode.aem.ui.touch.support.api.ui.Link;
import net.distilledcode.aem.ui.touch.support.api.ui.QuickActions;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.models.annotations.Model;

@Model(adaptables={Resource.class})
public class ConsoleItem {
    private static final String CRX_DE_PATH_PREFIX = "/crx/de/index.jsp#";
    private final ResourceResolver resolver;
    private final Resource resource;

    @Inject
    public ConsoleItem(Resource resource) {
        this.resource = resource;
        this.resolver = resource.getResourceResolver();
    }

    public String getId() {
        return this.resource.getPath();
    }

    public String getType() {
        if (DialogUtil.isClassicComponentDialog(this.resource)) {
            if (DialogUtil.isPageRenderingComponent(this.resource.getParent())) {
                return "Classic Page Dialog";
            }
            return "Classic Dialog";
        }
        return "Include";
    }

    public String getClassicPath() {
        return this.resource.getPath();
    }

    public String getTouchPath() {
        return DialogUtil.getTouchUiPath(this.resource);
    }

    public boolean isConverted() {
        return this.resolver.getResource(this.getTouchPath()) != null;
    }

    public Collection<Link> getClassicLinks() {
        ArrayList<Link> links = new ArrayList<Link>();
        String componentPath = this.getComponentPath();
        if (componentPath != null) {
            links.add(new Link("view", DialogUtil.getClassicUiDialogUrl(componentPath), Link.attributes("target", "_blank", "title", "View Classic Dialog")));
        }
        links.add(new Link("edit", CRX_DE_PATH_PREFIX + this.getClassicPath(), Link.attributes("target", "_blank", "x-cq-linkchecker", "skip", "title", "Open in CRX DE")));
        return links;
    }

    public Collection<Link> getTouchUILinks() {
        ArrayList<Link> links = new ArrayList<Link>();
        if (this.isConverted()) {
            String componentPath = this.getComponentPath();
            if (componentPath != null) {
                links.add(new Link("compare", "/apps/distilledcode/aem-touch-ui-support/ui/comparison.html" + componentPath, Link.attributes("target", "_blank", "title", "Compare Dialogs")));
                links.add(new Link("view", DialogUtil.getTouchUiDialogUrl(componentPath), Link.attributes("target", "_blank", "title", "View Touch UI Dialog")));
            }
            String crxdeHref = this.getTouchPath().replace("/cq:dialog", "/cq%3Adialog");
            links.add(new Link("edit", CRX_DE_PATH_PREFIX + crxdeHref, Link.attributes("target", "_blank", "x-cq-linkchecker", "skip", "title", "Open in CRX DE")));
        }
        return links;
    }

    public Collection<Link> getExampleLinks() {
        PageManager pageManager = (PageManager)Optional.ofNullable(this.resolver.adaptTo(PageManager.class)).orElseThrow(() -> new NullPointerException("Could not adapt ResourceResolver to PageManager"));
        String query = String.format("/jcr:root/content//*[@sling:resourceType='%s']", this.getResourceType());
        Iterable resources = () -> this.resolver.findResources(query, "xpath");
        return StreamSupport.stream(resources.spliterator(), false).map(arg_0 -> ((PageManager)pageManager).getContainingPage(arg_0)).filter(Objects::nonNull).map(page -> {
            String title = (String)page.getProperties().get("jcr:title", (Object)page.getName());
            return new Link(title, "/editor.html" + page.getPath() + ".html", Link.attributes("title", title, "target", "_blank"));
        }).distinct().limit(5L).collect(Collectors.toList());
    }

    private String getResourceType() {
        return StringUtils.removeStart((String)this.getParentPath(), (String)"/apps/");
    }

    public QuickActions getQuickActions() {
        return new QuickActions();
    }

    private String getComponentPath() {
        return DialogUtil.isClassicComponentDialog(this.resource) ? this.getParentPath() : null;
    }

    private String getParentPath() {
        return ResourceUtil.getParent((String)this.resource.getPath());
    }
}

