/*
 * Decompiled with CFR 0.152.
 */
package net.distilledcode.aem.ui.touch.support.impl.requestprocessing;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import net.distilledcode.aem.ui.touch.support.impl.requestprocessing.DelegatingServletOutputStream;
import org.jetbrains.annotations.NotNull;

public class SyntheticHttpServletResponse
implements HttpServletResponse {
    private final ResettableBufferedOutputStream outputStream;
    private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
    private DelegatingServletOutputStream servletOutputStream;
    private PrintWriter printWriter;
    private int statusCode = -1;
    private String statusMessage;
    private String characterEncoding = "ISO-8859-1";
    private int contentLength;
    private String contentType;
    private Locale locale = Locale.getDefault();
    private boolean isCommitted;

    public SyntheticHttpServletResponse(OutputStream outputStream) {
        this.outputStream = new ResettableBufferedOutputStream(outputStream);
    }

    public void addCookie(Cookie cookie) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean containsHeader(String name) {
        return this.headers.containsKey(name);
    }

    public String encodeURL(String url) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String encodeRedirectURL(String url) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String encodeUrl(String url) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String encodeRedirectUrl(String url) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void sendError(int sc, String msg) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void sendError(int sc) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void sendRedirect(String location) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setDateHeader(String name, long date) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void addDateHeader(String name, long date) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setHeader(String name, String value) {
        this.headers.put(name, SyntheticHttpServletResponse.asArrayList(value));
    }

    @NotNull
    private static List<String> asArrayList(String value) {
        ArrayList<String> values = new ArrayList<String>(1);
        values.add(value);
        return values;
    }

    public void addHeader(String name, String value) {
        List values = this.headers.computeIfAbsent(name, key -> new ArrayList());
        values.add(value);
    }

    public void setIntHeader(String name, int value) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void addIntHeader(String name, int value) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getStatusCode() {
        return this.statusCode == -1 ? 200 : this.statusCode;
    }

    public void setStatus(int statusCode) {
        this.setStatus(statusCode, null);
    }

    public void setStatus(int statusCode, String statusMessage) {
        this.statusCode = statusCode;
        this.statusMessage = statusMessage;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public String getContentType() {
        return this.contentType;
    }

    public ServletOutputStream getOutputStream() {
        if (this.printWriter != null) {
            throw new IllegalStateException("Writer was already retrieved before");
        }
        if (this.servletOutputStream == null) {
            this.servletOutputStream = new DelegatingServletOutputStream(this.outputStream);
        }
        return this.servletOutputStream;
    }

    public PrintWriter getWriter() {
        if (this.servletOutputStream != null) {
            throw new IllegalStateException("OutputStream was already retrieved before");
        }
        if (this.printWriter == null) {
            this.printWriter = new PrintWriter(new OutputStreamWriter(this.outputStream));
        }
        return this.printWriter;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setBufferSize(int size) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getBufferSize() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isCommitted() {
        return this.isCommitted;
    }

    public void flushBuffer() throws IOException {
        this.isCommitted = true;
        if (this.servletOutputStream != null) {
            this.servletOutputStream.flush();
        } else if (this.printWriter != null) {
            this.printWriter.flush();
        }
    }

    public void reset() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response already committed");
        }
        this.headers.clear();
        this.statusCode = -1;
        this.statusMessage = null;
        this.resetBuffer();
    }

    public void resetBuffer() {
        if (this.isCommitted()) {
            throw new IllegalStateException("Response already committed");
        }
        this.outputStream.reset();
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public Locale getLocale() {
        return this.locale;
    }

    private class ResettableBufferedOutputStream
    extends BufferedOutputStream {
        ResettableBufferedOutputStream(OutputStream outputStream) {
            super(outputStream, 8192);
        }

        void reset() {
            if (SyntheticHttpServletResponse.this.isCommitted) {
                throw new IllegalStateException("Response already committed");
            }
            this.buf = new byte[this.buf.length];
            this.count = 0;
        }

        @Override
        public synchronized void flush() throws IOException {
            SyntheticHttpServletResponse.this.isCommitted = true;
            super.flush();
        }
    }
}

