/*
 * Decompiled with CFR 0.152.
 */
package net.distilledcode.aem.ui.touch.support.impl.requestprocessing;

import com.google.common.base.Objects;
import java.io.BufferedReader;
import java.security.Principal;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionContext;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.FastDateFormat;

public class SyntheticHttpServletRequest
implements HttpServletRequest {
    private final Data data;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private String characterEncoding;

    public static Builder builder(String url) {
        return new Builder("GET", url);
    }

    public static Builder builder(String method, String url) {
        return new Builder(method, url);
    }

    private SyntheticHttpServletRequest(Data data) {
        this.data = data;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        return IteratorUtils.asEnumeration(this.attributes.keySet().iterator());
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public int getContentLength() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getContentType() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ServletInputStream getInputStream() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getParameter(String name) {
        String[] values = this.data.parameters.get(name);
        return values.length > 0 ? values[0] : null;
    }

    public Enumeration getParameterNames() {
        return IteratorUtils.asEnumeration(this.data.parameters.keySet().iterator());
    }

    public String[] getParameterValues(String name) {
        return this.data.parameters.get(name);
    }

    public Map getParameterMap() {
        return Collections.unmodifiableMap(this.data.parameters);
    }

    public String getProtocol() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getScheme() {
        return "http";
    }

    public String getServerName() {
        return "localhost";
    }

    public int getServerPort() {
        return 4502;
    }

    public BufferedReader getReader() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getRemoteAddr() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getRemoteHost() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public void setAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Locale getLocale() {
        return this.data.locale;
    }

    public Enumeration getLocales() {
        return IteratorUtils.asEnumeration(Collections.singletonList(this.getLocale()).iterator());
    }

    public boolean isSecure() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getRealPath(String path) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getRemotePort() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getLocalName() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getLocalAddr() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getLocalPort() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getAuthType() {
        return this.data.authType;
    }

    public Cookie[] getCookies() {
        return this.data.cookies;
    }

    public long getDateHeader(String name) {
        String header = this.getHeader(name);
        if (header == null) {
            return -1L;
        }
        try {
            FastDateFormat instance = FastDateFormat.getInstance((String)"EEE, dd MMM yyyy HH:mm:ss zzz");
            return instance.parse(header).getTime();
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public String getHeader(String name) {
        String[] values = this.data.headers.get(name.toLowerCase(Locale.ROOT));
        return values != null && values.length > 0 ? values[0] : null;
    }

    public Enumeration getHeaders(String name) {
        String[] values = this.data.headers.get(name.toLowerCase(Locale.ROOT));
        return IteratorUtils.asEnumeration(Arrays.asList(values).iterator());
    }

    public Enumeration getHeaderNames() {
        return IteratorUtils.asEnumeration(this.data.headers.keySet().iterator());
    }

    public int getIntHeader(String name) {
        String header = this.getHeader(name);
        return header == null ? -1 : Integer.parseInt(header);
    }

    public String getMethod() {
        return this.data.method;
    }

    public String getPathInfo() {
        return this.data.pathInfo;
    }

    public String getPathTranslated() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getContextPath() {
        return "";
    }

    public String getQueryString() {
        StringBuilder queryString = new StringBuilder();
        for (String key : this.data.parameters.keySet()) {
            for (String value : this.data.parameters.get(key)) {
                queryString.append(key).append("=").append(value).append("&");
            }
        }
        if (queryString.length() > 0) {
            queryString.setLength(queryString.length() - 1);
        }
        return queryString.toString();
    }

    public String getRemoteUser() {
        return "admin";
    }

    public boolean isUserInRole(String role) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public Principal getUserPrincipal() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getRequestedSessionId() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String getRequestURI() {
        return this.getContextPath() + this.getServletPath() + (String)Objects.firstNonNull((Object)this.getPathInfo(), (Object)"");
    }

    public StringBuffer getRequestURL() {
        return new StringBuffer().append(this.getScheme()).append("://").append(this.getServerName()).append(":").append(this.getServerPort()).append(this.getRequestURI());
    }

    public String getServletPath() {
        return this.data.servletPath;
    }

    public HttpSession getSession(boolean create) {
        if (!create) {
            return null;
        }
        return NullHttpSession.INSTANCE;
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public boolean isRequestedSessionIdValid() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isRequestedSessionIdFromCookie() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isRequestedSessionIdFromURL() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isRequestedSessionIdFromUrl() {
        throw new UnsupportedOperationException("Not implemented");
    }

    private static class NullHttpSession
    implements HttpSession {
        static final HttpSession INSTANCE = new NullHttpSession();

        private NullHttpSession() {
        }

        public long getCreationTime() {
            throw new UnsupportedOperationException("not implemented");
        }

        public String getId() {
            throw new UnsupportedOperationException("not implemented");
        }

        public long getLastAccessedTime() {
            throw new UnsupportedOperationException("not implemented");
        }

        public ServletContext getServletContext() {
            throw new UnsupportedOperationException("not implemented");
        }

        public void setMaxInactiveInterval(int interval) {
            throw new UnsupportedOperationException("not implemented");
        }

        public int getMaxInactiveInterval() {
            throw new UnsupportedOperationException("not implemented");
        }

        public HttpSessionContext getSessionContext() {
            throw new UnsupportedOperationException("not implemented");
        }

        public Object getAttribute(String name) {
            throw new UnsupportedOperationException("not implemented");
        }

        public Object getValue(String name) {
            throw new UnsupportedOperationException("not implemented");
        }

        public Enumeration getAttributeNames() {
            throw new UnsupportedOperationException("not implemented");
        }

        public String[] getValueNames() {
            throw new UnsupportedOperationException("not implemented");
        }

        public void setAttribute(String name, Object value) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void putValue(String name, Object value) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void removeAttribute(String name) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void removeValue(String name) {
            throw new UnsupportedOperationException("not implemented");
        }

        public void invalidate() {
            throw new UnsupportedOperationException("not implemented");
        }

        public boolean isNew() {
            throw new UnsupportedOperationException("not implemented");
        }
    }

    private static class Data {
        String method;
        String servletPath = "";
        String pathInfo;
        Locale locale = Locale.getDefault();
        Cookie[] cookies = new Cookie[0];
        String authType;
        final Map<String, String[]> headers = new HashMap<String, String[]>();
        final Map<String, String[]> parameters = new HashMap<String, String[]>();

        private Data() {
        }

        public static Data copy(Data data) {
            Data copy = new Data();
            copy.method = data.method;
            copy.servletPath = data.servletPath;
            copy.pathInfo = data.pathInfo;
            copy.locale = data.locale;
            copy.headers.putAll(data.headers);
            copy.parameters.putAll(data.parameters);
            copy.cookies = Arrays.copyOf(data.cookies, data.cookies.length);
            copy.authType = data.authType;
            return copy;
        }
    }

    public static class Builder {
        private final Data data = new Data();

        private Builder(String method, String url) {
            this.data.method = method.toUpperCase(Locale.ROOT);
            this.parseUrl(url);
        }

        private void parseUrl(String url) {
            this.data.servletPath = StringUtils.substringBefore((String)url, (String)"?");
            String queryString = StringUtils.substringAfter((String)url, (String)"?");
            String[] params = StringUtils.splitPreserveAllTokens((String)queryString, (String)"&=");
            for (int i = 1; i < params.length; i += 2) {
                this.addParameterValues(params[i - 1], params[i]);
            }
        }

        Builder withPathInfo(String pathInfo) {
            this.data.pathInfo = pathInfo;
            return this;
        }

        Builder addParameterValues(String name, String ... values) {
            this.data.parameters.compute(name, (key, oldValue) -> (String[])ArrayUtils.addAll((Object[])oldValue, (Object[])values));
            return this;
        }

        Builder withParameter(String name, String ... values) {
            this.data.parameters.put(name, values);
            return this;
        }

        Builder addHeaderValues(String name, String ... values) {
            this.data.headers.compute(name.toLowerCase(Locale.ROOT), (key, oldValue) -> (String[])ArrayUtils.addAll((Object[])oldValue, (Object[])values));
            return this;
        }

        Builder withHeader(String name, String ... values) {
            this.data.headers.put(name.toLowerCase(Locale.ROOT), values);
            return this;
        }

        Builder withLocale(Locale locale) {
            this.data.locale = locale;
            return this;
        }

        public Builder withCookies(Cookie[] cookies) {
            this.data.cookies = cookies;
            return this;
        }

        public HttpServletRequest build() {
            return new SyntheticHttpServletRequest(Data.copy(this.data));
        }

        public Builder withAuthType(String authType) {
            this.data.authType = authType;
            return this;
        }
    }
}

