/*
 * Decompiled with CFR 0.152.
 */
package net.distilledcode.aem.ui.touch.support.impl.image;

import java.awt.Dimension;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Optional;
import java.util.function.Supplier;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.apache.sling.api.resource.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImageReaderHelper {
    private final Supplier<InputStream> imageSupplier;

    public static ImageReaderHelper from(Supplier<InputStream> imageSuplier) {
        return new ImageReaderHelper(imageSuplier);
    }

    private ImageReaderHelper(Supplier<InputStream> imageSupplier) {
        this.imageSupplier = imageSupplier;
    }

    @Nullable
    public static InputStream getRenditionInputStream(@NotNull Resource rendition) {
        return (InputStream)rendition.adaptTo(InputStream.class);
    }

    @NotNull
    public static Dimension getImageDimensions(@NotNull ImageReader reader) throws IOException {
        return new Dimension(reader.getWidth(0), reader.getHeight(0));
    }

    public <R> Optional<R> withImageReader(ThrowingFunction<ImageReader, R, IOException> action) throws IOException {
        InputStream inputStream = this.imageSupplier.get();
        if (inputStream == null) {
            return Optional.empty();
        }
        try (ImageInputStream imageInputStream = ImageIO.createImageInputStream(inputStream);){
            ImageReader imageReader = ImageReaderHelper.getImageReader(imageInputStream);
            if (imageReader != null) {
                R result = action.apply(imageReader);
                Optional<R> optional = Optional.ofNullable(result);
                return optional;
            }
            Optional optional = Optional.empty();
            return optional;
        }
    }

    private static ImageReader getImageReader(ImageInputStream imageInputStream) {
        Iterator<ImageReader> readers = ImageIO.getImageReaders(imageInputStream);
        while (readers.hasNext()) {
            ImageReader reader = readers.next();
            if (readers.hasNext() && "ch.randelshofer.media.jpeg.CMYKJPEGImageReader".equals(reader.getClass().getName())) continue;
            reader.setInput(imageInputStream);
            return reader;
        }
        return null;
    }

    public static interface ThrowingFunction<S, R, T extends Exception> {
        public R apply(S var1) throws T;
    }
}

