/*
 * Decompiled with CFR 0.152.
 */
package net.distilledcode.aem.ui.touch.support.impl.granite.ui;

import com.adobe.granite.ui.components.ExpressionResolver;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.servlet.Servlet;
import org.apache.sling.commons.osgi.PropertiesUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProxyServletManager<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractProxyServletManager.class);
    private final Map<ServiceReference<T>, ServletRegistration> registrations = new ConcurrentHashMap<ServiceReference<T>, ServletRegistration>();
    private final Set<ServiceReference<T>> earlyFactories = new CopyOnWriteArraySet<ServiceReference<T>>();
    private volatile boolean active;
    private ExpressionResolver expressionResolver;
    private final ServletFactory<T> servletFactory;
    private final String resourceTypesProperty;
    private final String prefixProperty;

    public AbstractProxyServletManager(ServletFactory<T> servletFactory, String resourceTypesProperty, String prefixProperty) {
        this.servletFactory = servletFactory;
        this.resourceTypesProperty = resourceTypesProperty;
        this.prefixProperty = prefixProperty;
    }

    protected abstract void activate();

    protected final void activate(ExpressionResolver expressionResolver) {
        this.expressionResolver = expressionResolver;
        this.active = true;
        this.registerEarlyFactories();
    }

    protected void deactivate() {
        this.active = false;
        this.earlyFactories.clear();
        if (!this.registrations.isEmpty()) {
            LOG.warn("Remaining registrations on deactivate (will be unregistered): {}", this.registrations);
            this.registrations.values().forEach(ServletRegistration::unregister);
            this.registrations.clear();
        }
    }

    protected void bindFactory(@NotNull ServiceReference<T> reference) {
        if (!this.isActive()) {
            this.earlyFactories.add(reference);
            return;
        }
        String[] resourceTypes = PropertiesUtil.toStringArray((Object)reference.getProperty(this.resourceTypesProperty));
        String prefix = PropertiesUtil.toString((Object)reference.getProperty(this.prefixProperty), null);
        if (resourceTypes.length == 0) {
            LOG.warn("Skipping DataSourceFactory without '{}' property: {}", (Object)resourceTypes, reference);
            return;
        }
        ServletRegistration reg = new ServletRegistration(reference, resourceTypes, prefix);
        ServletRegistration oldRegistration = this.registrations.put(reference, reg);
        if (oldRegistration != null) {
            LOG.info("Unregistered previously registered servlet for {}", (Object)oldRegistration);
            oldRegistration.unregister();
        }
    }

    protected void unbindFactory(@NotNull ServiceReference<T> reference) {
        this.earlyFactories.remove(reference);
        ServletRegistration registration = this.registrations.remove(reference);
        if (registration != null) {
            LOG.info("Unregistered servlet for {}", reference);
            registration.unregister();
        }
    }

    private boolean isActive() {
        return this.active;
    }

    private void registerEarlyFactories() {
        HashSet<ServiceReference<T>> copiesToBeRegistered = new HashSet<ServiceReference<T>>(this.earlyFactories);
        this.earlyFactories.clear();
        for (ServiceReference serviceReference : copiesToBeRegistered) {
            if (!this.isActive()) break;
            this.bindFactory(serviceReference);
        }
    }

    protected static interface ServletFactory<FACTORY> {
        public Servlet createServlet(FACTORY var1, ExpressionResolver var2);
    }

    private class ServletRegistration {
        private final BundleContext bundleContext;
        private final ServiceReference<T> factoryReference;
        private final ServiceRegistration<Servlet> servletRegistration;

        ServletRegistration(@NotNull ServiceReference<T> factoryReference, @Nullable String[] resourceTypes, String prefix) {
            this.factoryReference = factoryReference;
            this.bundleContext = factoryReference.getBundle().getBundleContext();
            Object factory = this.bundleContext.getService(factoryReference);
            Servlet dataSourceServlet = AbstractProxyServletManager.this.servletFactory.createServlet(factory, AbstractProxyServletManager.this.expressionResolver);
            Hashtable<String, Object> servletProps = new Hashtable<String, Object>();
            servletProps.put("sling.servlet.resourceTypes", resourceTypes);
            servletProps.put("sling.servlet.prefix", prefix == null ? "0" : prefix);
            servletProps.put("service.description", "Servlet registered by " + AbstractProxyServletManager.this.getClass().getSimpleName() + " on behalf of " + factory.getClass().getName());
            this.servletRegistration = this.bundleContext.registerService(Servlet.class, (Object)dataSourceServlet, servletProps);
        }

        void unregister() {
            this.servletRegistration.unregister();
            this.bundleContext.ungetService(this.factoryReference);
        }
    }
}

