/*
 * Decompiled with CFR 0.152.
 */
package net.distilledcode.aem.ui.touch.support.impl.foundation;

import com.adobe.granite.ui.components.ExpressionHelper;
import com.adobe.granite.ui.components.ds.ValueMapResource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.stream.JsonParsingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.distilledcode.aem.ui.touch.support.impl.requestprocessing.SyntheticHttpServletRequest;
import net.distilledcode.aem.ui.touch.support.impl.requestprocessing.SyntheticHttpServletResponse;
import net.distilledcode.aem.ui.touch.support.spi.granite.ui.datasource.DataSourceFactory;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.request.RequestProgressTracker;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.engine.SlingRequestProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={DataSourceFactory.class}, property={"datasource.resourceTypes=distilledcode/cq/wcm/foundation/json"})
public class JsonOptionsDataSourceFactory
extends DataSourceFactory {
    private static final Logger LOG = LoggerFactory.getLogger(JsonOptionsDataSourceFactory.class);
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private SlingRequestProcessor requestProcessor;

    @Override
    @Nullable
    public Iterable<Resource> computeResources(@NotNull SlingHttpServletRequest request, @NotNull Resource dsResource, @NotNull ExpressionHelper ex) {
        ValueMap datasourceProps = dsResource.getValueMap();
        String selectedValue = (String)datasourceProps.get("selected", String.class);
        String url = (String)datasourceProps.get("url", String.class);
        if (url == null) {
            return null;
        }
        String interpolatedUrl = ex.getString(url);
        ResourceResolver resolver = request.getResourceResolver();
        HttpServletRequest syntheticRequest = SyntheticHttpServletRequest.builder(interpolatedUrl).build();
        Object requestProgressTracker = request.getAttribute(RequestProgressTracker.class.getName());
        if (requestProgressTracker != null) {
            syntheticRequest.setAttribute(RequestProgressTracker.class.getName(), requestProgressTracker);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        SyntheticHttpServletResponse syntheticResponse = new SyntheticHttpServletResponse(outputStream);
        try {
            this.requestProcessor.processRequest(syntheticRequest, (HttpServletResponse)syntheticResponse, resolver);
            syntheticResponse.flushBuffer();
            ArrayList<Resource> resources = new ArrayList<Resource>();
            int statusCode = syntheticResponse.getStatusCode();
            if (200 <= statusCode && statusCode < 300) {
                String outputJson = outputStream.toString("UTF-8");
                try (JsonReader reader = Json.createReader((Reader)new StringReader(outputJson));){
                    try {
                        JsonArray options = reader.readArray();
                        for (int i = 0; i < options.size(); ++i) {
                            JsonObject option = options.getJsonObject(i);
                            ValueMapDecorator props = new ValueMapDecorator(new HashMap());
                            props.put("text", (Object)option.getString("text"));
                            String value = option.getString("value");
                            props.put("value", (Object)value);
                            if (Objects.equals(value, selectedValue)) {
                                props.put("selected", (Object)true);
                            }
                            resources.add((Resource)new ValueMapResource(resolver, "", null, (ValueMap)props));
                        }
                    }
                    catch (JsonParsingException e) {
                        LOG.warn("Failed to parse json '{}'", (Object)outputJson.substring(0, Math.min(outputJson.length(), 256)), (Object)e);
                    }
                }
            } else {
                LOG.warn("Retrieving '{}' returned response with non 2xx status code: '{}'", (Object)interpolatedUrl, (Object)statusCode);
            }
            return resources;
        }
        catch (IOException | ServletException e) {
            LOG.warn("Failed to retrieve or process JSON from {}", (Object)interpolatedUrl, (Object)e);
            return null;
        }
    }
}

