/*
 * Decompiled with CFR 0.152.
 */
package net.distilledcode.aem.ui.touch.support.impl.fixes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import net.distilledcode.aem.ui.touch.support.impl.fixes.MergingValueMap;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceDecorator;
import org.apache.sling.api.resource.ResourceWrapper;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.service.component.annotations.Component;

@Component(service={Filter.class, ResourceDecorator.class}, property={"sling.filter.scope=REQUEST", "sling.filter.resourceTypes=cq/gui/components/siteadmin/admin/createpagewizard/properties"})
public class IncludeRespectingShowOnCreate
implements Filter,
ResourceDecorator {
    public static final String FILTER_RESOURCE_TYPE = "cq/gui/components/siteadmin/admin/createpagewizard/properties";
    public static final Collection<String> INCLUDE_RESOURCE_TYPES = Arrays.asList("granite/ui/components/coral/foundation/include", "granite/ui/components/foundation/include");
    private final ThreadLocal<List<String>> includedPathsHolder = new ThreadLocal();

    public void init(FilterConfig filterConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            SlingHttpServletRequest slingRequest;
            String resourceType;
            if (request instanceof SlingHttpServletRequest && Objects.equals(FILTER_RESOURCE_TYPE, resourceType = (slingRequest = (SlingHttpServletRequest)request).getResource().getResourceType())) {
                this.includedPathsHolder.set(new ArrayList());
            }
            chain.doFilter(request, response);
        }
        finally {
            this.includedPathsHolder.remove();
        }
    }

    public void destroy() {
    }

    @Nullable
    public Resource decorate(@NotNull Resource resource) {
        boolean showOnCreate;
        List<String> includedPaths = this.includedPathsHolder.get();
        if (includedPaths == null) {
            return resource;
        }
        if (INCLUDE_RESOURCE_TYPES.contains(resource.getResourceType()) && !(showOnCreate = ((Boolean)resource.getValueMap().get("cq:showOnCreate", (Object)true)).booleanValue())) {
            String includePath = (String)resource.getValueMap().get("path", String.class);
            includedPaths.add(includePath);
        }
        if (includedPaths.remove(resource.getPath())) {
            return new ResourceWrapper(resource){

                @NotNull
                public ValueMap getValueMap() {
                    return new MergingValueMap(Arrays.asList(new ValueMapDecorator(Collections.singletonMap("cq:showOnCreate", false)), super.getValueMap()));
                }
            };
        }
        return resource;
    }

    @Nullable
    public Resource decorate(@NotNull Resource resource, @NotNull HttpServletRequest request) {
        return this.decorate(resource);
    }
}

