/*
 * Decompiled with CFR 0.152.
 */
package net.distilledcode.aem.ui.touch.support.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import net.distilledcode.aem.ui.touch.support.api.ui.consoles.ConsoleItem;
import net.distilledcode.aem.ui.touch.support.api.ui.consoles.ConversionConfig;
import net.distilledcode.aem.ui.touch.support.impl.ui.ConsoleItemDataSource;
import net.distilledcode.aem.ui.touch.support.spi.DialogConverter;
import org.apache.commons.lang3.StringUtils;
import org.apache.jackrabbit.vault.fs.api.PathFilterSet;
import org.apache.jackrabbit.vault.fs.api.WorkspaceFilter;
import org.apache.jackrabbit.vault.fs.config.DefaultWorkspaceFilter;
import org.apache.jackrabbit.vault.packaging.JcrPackage;
import org.apache.jackrabbit.vault.packaging.JcrPackageDefinition;
import org.apache.jackrabbit.vault.packaging.JcrPackageManager;
import org.apache.jackrabbit.vault.packaging.PackageException;
import org.apache.jackrabbit.vault.packaging.Packaging;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestPathInfo;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.jetbrains.annotations.NotNull;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicyOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Servlet.class}, property={"sling.servlet.methods=GET", "sling.servlet.methods=POST", "sling.servlet.resourceTypes=distilledcode/aem-touch-ui-support/ui/components/conversion-config"})
public class DialogConversionServlet
extends SlingAllMethodsServlet {
    private static final Logger LOG = LoggerFactory.getLogger(DialogConversionServlet.class);
    private static final String PARAM_PATHS = "paths";
    private static final String PARAM_FORCE = "force";
    @Reference(policyOption=ReferencePolicyOption.GREEDY, cardinality=ReferenceCardinality.OPTIONAL)
    private DialogConverter dialogConverter;
    @Reference(policyOption=ReferencePolicyOption.GREEDY)
    private Packaging packaging;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doGet(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws ServletException, IOException {
        RequestPathInfo requestPathInfo = request.getRequestPathInfo();
        String selector = requestPathInfo.getSelectorString();
        Resource resource = request.getResource();
        String[] searchRoots = ConversionConfig.getScope(resource);
        if (searchRoots.length == 0) {
            response.sendError(404, "No scope defined in configuration");
            return;
        }
        if (!Objects.equals(selector, "package")) {
            super.doGet(request, response);
            return;
        }
        ResourceResolver resolver = request.getResourceResolver();
        Iterable convertibleResources = ConsoleItemDataSource.getConvertibleResources(resolver, searchRoots)::iterator;
        List<PathFilterSet> convertedPaths = StreamSupport.stream(convertibleResources.spliterator(), false).map(ConsoleItem::new).filter(ConsoleItem::isConverted).map(ConsoleItem::getTouchPath).map(PathFilterSet::new).collect(Collectors.toList());
        String packagePath = null;
        Session session = (Session)Optional.ofNullable(resolver.adaptTo(Session.class)).orElseThrow(() -> new NullPointerException("Cannot adapt ResourceResolver to Session"));
        try {
            JcrPackageManager jcrPackageManager = this.packaging.getPackageManager(session);
            JcrPackage jcrPackage = jcrPackageManager.create("aem-touch-ui-support", "converted");
            Node node = jcrPackage.getNode();
            packagePath = node == null ? null : node.getPath();
            JcrPackageDefinition definition = Optional.ofNullable(jcrPackage.getDefinition()).orElseThrow(() -> new NullPointerException("JCR Package definition is null"));
            DefaultWorkspaceFilter filter = new DefaultWorkspaceFilter();
            convertedPaths.forEach(arg_0 -> ((DefaultWorkspaceFilter)filter).add(arg_0));
            definition.setFilter((WorkspaceFilter)filter, false);
            session.save();
            response.setHeader("Content-Disposition", "attachment; filename=\"" + resource.getName() + "-converted-dialogs.zip\"");
            response.setContentType("application/zip");
            jcrPackageManager.assemble(definition, null, (OutputStream)response.getOutputStream());
            if (packagePath == null) return;
        }
        catch (RepositoryException | PackageException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                if (packagePath == null) throw throwable;
                try {
                    session.getNode(packagePath).remove();
                    session.save();
                    throw throwable;
                }
                catch (RepositoryException e2) {
                    LOG.error("Failed to remove temporary package '{}'", packagePath);
                }
                throw throwable;
            }
        }
        try {
            session.getNode(packagePath).remove();
            session.save();
            return;
        }
        catch (RepositoryException e) {
            LOG.error("Failed to remove temporary package '{}'", (Object)packagePath);
            return;
        }
    }

    protected void doPost(@NotNull SlingHttpServletRequest request, @NotNull SlingHttpServletResponse response) throws IOException {
        Set paths = Optional.ofNullable(request.getRequestParameters(PARAM_PATHS)).map(Arrays::stream).orElseGet(Stream::empty).map(RequestParameter::getString).collect(Collectors.toSet());
        String[] searchRoots = ConversionConfig.getScope(request.getResource());
        List<String> orderedPaths = ConsoleItemDataSource.getConvertibleResources(request.getResourceResolver(), searchRoots).map(Resource::getPath).filter(paths::contains).collect(Collectors.toList());
        boolean force = Optional.ofNullable(request.getRequestParameter(PARAM_FORCE)).map(RequestParameter::getString).map(Boolean::parseBoolean).orElse(false);
        if (paths.isEmpty()) {
            LOG.warn("Missing or empty parameter 'paths'");
            response.setContentType("text/plain");
            response.getWriter().println("Missing or empty parameter 'paths'");
            response.setStatus(400);
            return;
        }
        if (this.dialogConverter == null) {
            response.setContentType("text/plain");
            response.getWriter().println("No DialogConverter is available");
            response.setStatus(503);
            return;
        }
        try {
            ResourceResolver resolver = request.getResourceResolver();
            Collection<DialogConverter.Result> results = this.dialogConverter.convert(resolver, orderedPaths, force);
            response.setContentType("text/plain");
            PrintWriter writer = response.getWriter();
            for (DialogConverter.Result result : results) {
                String error = result.getError();
                if (error != null) {
                    String[] lines;
                    writer.append("Failed to convert ").println(result.getPath());
                    for (String line : lines = StringUtils.split((String)error, (String)"\n")) {
                        writer.append("    ").println(line);
                    }
                    continue;
                }
                writer.append("Successfully converted ").println(result.getPath());
            }
        }
        catch (Exception e) {
            response.setContentType("text/plain");
            LOG.warn("There was a problem during dialog conversion: ", (Throwable)e);
            PrintWriter writer = response.getWriter();
            writer.println("There was an error (see logs for stack trace):");
            for (Throwable ex = e; ex != null; ex = ex.getCause()) {
                writer.println(ex.getMessage());
            }
        }
    }
}

