/*
 * Decompiled with CFR 0.152.
 */
package net.distilledcode.aem.ui.touch.support.api.ui.granite;

import com.adobe.granite.ui.components.Config;
import com.adobe.granite.ui.components.Value;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import net.distilledcode.aem.ui.touch.support.api.ui.granite.Component;
import net.distilledcode.aem.ui.touch.support.api.ui.granite.CoralUtil;
import org.apache.commons.lang3.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.jetbrains.annotations.NotNull;

public abstract class Field<V>
extends Component {
    @NotNull
    private final Value value;

    protected Field(@NotNull SlingHttpServletRequest request) {
        super(request);
        this.value = new Value(request, new Config(this.resource));
    }

    public String getLabel() {
        return this.i18n.getVar((String)this.properties.get("fieldLabel", String.class));
    }

    public String getDescription() {
        return this.i18n.getVar((String)this.properties.get("fieldDescription", String.class));
    }

    public String getName() {
        return (String)this.properties.get("name", String.class);
    }

    public boolean isRequired() {
        return (Boolean)this.properties.get("required", (Object)false);
    }

    public boolean isDisabled() {
        return (Boolean)this.properties.get("disabled", (Object)false);
    }

    public boolean isRenderWrapper() {
        return true;
    }

    @Override
    public Map<String, Object> getAttributes() {
        Map<String, Object> attributes = super.getAttributes();
        attributes.put("name", this.getName());
        attributes.compute("class", CoralUtil.addClasses("coral-Form-field"));
        attributes.put("required", this.isRequired());
        attributes.put("disabled", this.isDisabled());
        this.addValidationAttributes(attributes);
        return attributes;
    }

    @NotNull
    protected abstract V getDefaultValue();

    @NotNull
    protected final Optional<V> getStoredValue() {
        V defaultValue = this.getDefaultValue();
        return this.getStoredValueByName(this.getName(), defaultValue);
    }

    @NotNull
    protected final <T> Optional<T> getStoredValueByName(String name, Class<T> type) {
        return Optional.ofNullable(this.value.get(name, type));
    }

    @NotNull
    protected final Optional<V> getStoredValueByName(String name, V defaultValue) {
        return Optional.ofNullable(this.value.val(name, defaultValue));
    }

    protected void addStoredValue(Map<String, Object> attributes) {
        this.getStoredValue().ifPresent(val -> attributes.put("value", val));
    }

    private void addValidationAttributes(Map<String, Object> attributes) {
        String validation = StringUtils.join((Object[])((Object[])this.properties.get("validation", (Object)new String[0])), (char)' ');
        attributes.put("data-foundation-validation", validation);
        attributes.put("data-validation", validation);
    }

    public Map<String, Object> getWrapperAttributes() {
        LinkedHashMap<String, Object> attributes = new LinkedHashMap<String, Object>();
        attributes.put("hidden", this.properties.get("renderHidden", (Object)false));
        attributes.compute("class", CoralUtil.addClasses("coral-Form-fieldwrapper", (String)this.properties.get("wrapperClass", String.class), "foundation-field-edit"));
        return attributes;
    }
}

