/*
 * Decompiled with CFR 0.152.
 */
package net.distilledcode.aem.ui.touch.support.api.ui.granite;

import com.adobe.granite.ui.components.ExpressionHelper;
import com.day.cq.commons.date.RelativeTimeFormat;
import com.day.cq.dam.api.Asset;
import com.day.cq.dam.api.RenditionPicker;
import com.day.cq.dam.commons.util.PrefixRenditionPicker;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import net.distilledcode.aem.ui.touch.support.api.ui.granite.CoralUtil;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.wrappers.ValueMapDecorator;
import org.apache.sling.models.annotations.Model;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={SlingHttpServletRequest.class})
public class ColumnPreviewAsset {
    private final SlingHttpServletRequest request;
    private final ResourceResolver resourceResolver;
    @Nullable
    private final ExpressionHelper expressionHelper;
    private final Resource contentResource;

    @Inject
    public ColumnPreviewAsset(SlingHttpServletRequest request) {
        this.request = request;
        this.resourceResolver = request.getResourceResolver();
        this.expressionHelper = CoralUtil.getExpressionHelper(request);
        String expression = (String)request.getResource().getValueMap().get("path", String.class);
        String path = this.expressionHelper != null ? (String)this.expressionHelper.get(expression, String.class) : expression;
        this.contentResource = path != null ? this.resourceResolver.getResource(path) : null;
    }

    @Nullable
    public String getThumbnailHref() {
        return this.withAsset().map(asset -> this.getThumbnailPath((Asset)asset) + "?" + this.getCacheKiller((Asset)asset)).orElse(null);
    }

    private String getCacheKiller(Asset asset) {
        long lastModified = asset.getLastModified() / 1000L * 1000L;
        return "ch_ck=" + lastModified;
    }

    @NotNull
    private String getThumbnailPath(Asset asset) {
        return asset.getRendition((RenditionPicker)new PrefixRenditionPicker("cq5dam.thumbnail.319.319")).getPath();
    }

    @Nullable
    public String getTitle() {
        return this.withAsset().map(asset -> new ValueMapDecorator(asset.getMetadata())).map(vm -> (String)vm.get("dc:title", String.class)).orElse(null);
    }

    @Nullable
    public String getLastModifiedRelative() {
        return Optional.ofNullable(this.getLastModified()).map(this::toRelativeDate).orElse(null);
    }

    @Nullable
    public Long getLastModified() {
        return this.withAsset().map(Asset::getLastModified).orElse(null);
    }

    @Nullable
    public String getMimeType() {
        return this.withAsset().map(Asset::getMimeType).orElse(null);
    }

    public boolean isPublished() {
        return Optional.ofNullable(this.contentResource).map(assetRes -> assetRes.getChild("jcr:content")).map(Resource::getValueMap).map(props -> (String)props.get("cq:lastReplicationAction", String.class)).map(lastAction -> Objects.equals("Activate", lastAction)).orElse(false);
    }

    private Optional<Asset> withAsset() {
        return Optional.ofNullable(this.contentResource).map(res -> (Asset)res.adaptTo(Asset.class));
    }

    private String toRelativeDate(long timeMillis) {
        RelativeTimeFormat rtf = new RelativeTimeFormat("r", this.request.getResourceBundle(this.request.getLocale()));
        return rtf.format(timeMillis, true);
    }
}

