/*
 * Decompiled with CFR 0.152.
 */
package net.distilledcode.aem.ui.touch.support.api.ui.consoles;

import java.util.Optional;
import javax.inject.Inject;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.models.annotations.Model;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Model(adaptables={Resource.class})
public class ConversionConfig {
    private final Resource resource;
    private final ValueMap properties;

    @Inject
    public ConversionConfig(@NotNull Resource resource) {
        this.resource = resource;
        this.properties = resource.getValueMap();
    }

    public String getTitle() {
        return (String)this.properties.get("jcr:title", String.class);
    }

    public String getDescription() {
        return (String)this.properties.get("jcr:description", String.class);
    }

    public String getPath() {
        return this.resource.getPath();
    }

    @NotNull
    public String[] getScope() {
        return (String[])this.properties.get("paths", (Object)new String[0]);
    }

    public String getConsoleHref() {
        return "/apps/distilledcode/aem-touch-ui-support/ui/content/converter/console.html" + this.getPath();
    }

    public static String[] getScope(@Nullable Resource configResource) {
        return Optional.ofNullable(configResource).map(ConversionConfig::new).map(ConversionConfig::getScope).orElse(new String[0]);
    }
}

