/*
 * Decompiled with CFR 0.152.
 */
package net.distilledcode.aem.ui.touch.support.api.ui;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Link {
    private final String icon;
    private final String title;
    private final String href;
    private final Map<String, String> extraAttributes;

    public Link(@NotNull String title, @NotNull String href) {
        this(null, title, href, Collections.emptyMap());
    }

    public Link(@NotNull String title, @NotNull String href, @NotNull Map<String, String> extraAttributes) {
        this(null, title, href, extraAttributes);
    }

    public Link(@Nullable String icon, @NotNull String title, @NotNull String href) {
        this(icon, title, href, Collections.emptyMap());
    }

    public Link(@Nullable String icon, @NotNull String title, @NotNull String href, @NotNull Map<String, String> extraAttributes) {
        this.icon = icon;
        this.title = title;
        this.href = href;
        this.extraAttributes = extraAttributes;
    }

    public String getIcon() {
        return this.icon;
    }

    public String getTitle() {
        return this.title;
    }

    public String getHref() {
        return this.href;
    }

    public Map<String, String> getAttributes() {
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        attributes.put("title", this.title);
        attributes.put("href", this.href);
        attributes.putAll(this.extraAttributes);
        return attributes;
    }

    public static Map<String, String> attributes(String ... attributeDefs) {
        if (attributeDefs.length % 2 != 0) {
            throw new IllegalArgumentException("Even number of arguments required");
        }
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        for (int i = 0; i < attributeDefs.length; i += 2) {
            String key = attributeDefs[i];
            String value = attributeDefs[i + 1];
            attributes.put(key, value);
        }
        return attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Link)) {
            return false;
        }
        Link link = (Link)o;
        return Objects.equals(this.icon, link.icon) && this.title.equals(link.title) && this.href.equals(link.href) && this.extraAttributes.equals(link.extraAttributes);
    }

    public int hashCode() {
        return Objects.hash(this.icon, this.title, this.href, this.extraAttributes);
    }
}

