/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.nullable;

import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.annotations.ownership.NonCaptured;
import net.digitalid.utility.annotations.parameter.Unmodified;
import net.digitalid.utility.functional.failable.FailableBinaryFunction;
import net.digitalid.utility.functional.failable.FailableConsumer;
import net.digitalid.utility.functional.failable.FailablePredicate;
import net.digitalid.utility.functional.failable.FailableUnaryFunction;
import net.digitalid.utility.validation.annotations.type.Utility;

@Utility
public class Evaluate {
    @Pure
    public static <INPUT, EXCEPTION extends Exception> void consumerIfNotNull(@Captured INPUT input, FailableConsumer<? super INPUT, ? extends EXCEPTION> consumer) throws EXCEPTION {
        if (input != null) {
            consumer.consume(input);
        }
    }

    @Pure
    public static <INPUT, EXCEPTION extends Exception> boolean predicateIfNotNull(@NonCaptured @Unmodified INPUT input, FailablePredicate<? super INPUT, ? extends EXCEPTION> predicate, boolean defaultOutput) throws EXCEPTION {
        return input != null ? predicate.evaluate(input) : defaultOutput;
    }

    @Pure
    public static <INPUT, EXCEPTION extends Exception> boolean predicateIfNotNull(@NonCaptured @Unmodified INPUT input, FailablePredicate<? super INPUT, ? extends EXCEPTION> predicate) throws EXCEPTION {
        return Evaluate.predicateIfNotNull(input, predicate, false);
    }

    @Pure
    public static <INPUT, OUTPUT, EXCEPTION extends Exception> OUTPUT functionIfNotNull(@NonCaptured @Unmodified INPUT input, FailableUnaryFunction<? super INPUT, ? extends OUTPUT, ? extends EXCEPTION> function, @NonCaptured @Unmodified OUTPUT defaultOutput) throws EXCEPTION {
        return input != null ? function.evaluate(input) : defaultOutput;
    }

    @Pure
    public static <INPUT, OUTPUT, EXCEPTION extends Exception> OUTPUT functionIfNotNull(@NonCaptured @Unmodified INPUT input, FailableUnaryFunction<? super INPUT, ? extends OUTPUT, ? extends EXCEPTION> function) throws EXCEPTION {
        return Evaluate.functionIfNotNull(input, function, null);
    }

    @Pure
    public static <INPUT0, INPUT1, OUTPUT, EXCEPTION extends Exception> OUTPUT functionIfFirstNotNull(@NonCaptured @Unmodified INPUT0 input0, @NonCaptured @Unmodified INPUT1 input1, FailableBinaryFunction<? super INPUT0, ? super INPUT1, ? extends OUTPUT, ? extends EXCEPTION> function, @NonCaptured @Unmodified OUTPUT defaultOutput) throws EXCEPTION {
        return input0 != null ? function.evaluate(input0, input1) : defaultOutput;
    }

    @Pure
    public static <INPUT0, INPUT1, OUTPUT, EXCEPTION extends Exception> OUTPUT functionIfFirstNotNull(@NonCaptured @Unmodified INPUT0 input0, @NonCaptured @Unmodified INPUT1 input1, FailableBinaryFunction<? super INPUT0, ? super INPUT1, ? extends OUTPUT, ? extends EXCEPTION> function) throws EXCEPTION {
        return Evaluate.functionIfFirstNotNull(input0, input1, function, null);
    }

    @Pure
    public static <INPUT0, INPUT1, OUTPUT, EXCEPTION extends Exception> OUTPUT functionIfBothNotNull(@NonCaptured @Unmodified INPUT0 input0, @NonCaptured @Unmodified INPUT1 input1, FailableBinaryFunction<? super INPUT0, ? super INPUT1, ? extends OUTPUT, ? extends EXCEPTION> function, @NonCaptured @Unmodified OUTPUT defaultOutput) throws EXCEPTION {
        return input0 != null && input1 != null ? function.evaluate(input0, input1) : defaultOutput;
    }

    @Pure
    public static <INPUT0, INPUT1, OUTPUT, EXCEPTION extends Exception> OUTPUT functionIfBothNotNull(@NonCaptured @Unmodified INPUT0 input0, @NonCaptured @Unmodified INPUT1 input1, FailableBinaryFunction<? super INPUT0, ? super INPUT1, ? extends OUTPUT, ? extends EXCEPTION> function) throws EXCEPTION {
        return Evaluate.functionIfBothNotNull(input0, input1, function, null);
    }
}

