/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.iterators;

import java.util.Iterator;
import net.digitalid.utility.annotations.generics.Specifiable;
import net.digitalid.utility.annotations.method.Impure;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Capturable;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.functional.iterators.DoubleIteratorBasedIterator;
import net.digitalid.utility.tuples.Pair;
import net.digitalid.utility.validation.annotations.type.Mutable;

@Mutable
public class ZippingIterator<@Specifiable INPUT0, @Specifiable INPUT1>
extends DoubleIteratorBasedIterator<Pair<INPUT0, INPUT1>, INPUT0, INPUT1> {
    protected final boolean shortest;

    protected ZippingIterator(@Captured Iterator<? extends INPUT0> primaryIterator, @Captured Iterator<? extends INPUT1> secondaryIterator, boolean shortest) {
        super(primaryIterator, secondaryIterator);
        this.shortest = shortest;
    }

    @Pure
    @Capturable
    public static <INPUT0, INPUT1> ZippingIterator<INPUT0, INPUT1> with(@Captured Iterator<? extends INPUT0> primaryIterator, @Captured Iterator<? extends INPUT1> secondaryIterator, boolean shortest) {
        return new ZippingIterator<INPUT0, INPUT1>(primaryIterator, secondaryIterator, shortest);
    }

    @Override
    @Pure
    public boolean hasNext() {
        if (this.shortest) {
            return this.primaryIterator.hasNext() && this.secondaryIterator.hasNext();
        }
        return this.primaryIterator.hasNext() || this.secondaryIterator.hasNext();
    }

    @Override
    @Impure
    public Pair<INPUT0, INPUT1> next() {
        if (this.shortest) {
            return Pair.of(this.primaryIterator.next(), this.secondaryIterator.next());
        }
        return Pair.of(this.primaryIterator.hasNext() || !this.secondaryIterator.hasNext() ? this.primaryIterator.next() : null, this.secondaryIterator.hasNext() || !this.primaryIterator.hasNext() ? this.secondaryIterator.next() : null);
    }
}

