/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.iterators;

import java.util.NoSuchElementException;
import net.digitalid.utility.annotations.generics.Specifiable;
import net.digitalid.utility.annotations.method.Impure;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Capturable;
import net.digitalid.utility.annotations.ownership.NonCapturable;
import net.digitalid.utility.functional.iterators.ReadOnlyIterator;
import net.digitalid.utility.validation.annotations.type.Mutable;

@Mutable
public class ReversingIterator<@Specifiable ELEMENT>
extends ReadOnlyIterator<ELEMENT> {
    protected final ELEMENT[] elements;
    private int cursor;

    @SafeVarargs
    protected ReversingIterator(ELEMENT ... elements) {
        this.elements = elements;
        this.cursor = elements.length - 1;
    }

    @Pure
    @SafeVarargs
    @Capturable
    public static <ELEMENT> ReversingIterator<ELEMENT> with(ELEMENT ... elements) {
        return new ReversingIterator<ELEMENT>(elements);
    }

    @Override
    @Pure
    public boolean hasNext() {
        return this.cursor >= 0;
    }

    @Override
    @Impure
    @NonCapturable
    public ELEMENT next() {
        if (this.hasNext()) {
            return this.elements[this.cursor--];
        }
        throw new NoSuchElementException();
    }
}

