/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.iterators;

import java.util.ListIterator;
import java.util.Objects;
import net.digitalid.utility.annotations.generics.Specifiable;
import net.digitalid.utility.annotations.method.Impure;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Capturable;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.annotations.ownership.NonCaptured;
import net.digitalid.utility.annotations.parameter.Unmodified;
import net.digitalid.utility.functional.iterators.ReadOnlyIterableIterator;
import net.digitalid.utility.validation.annotations.type.Mutable;

@Mutable
public class ReadOnlyListIterator<@Specifiable ELEMENT>
extends ReadOnlyIterableIterator<ELEMENT>
implements ListIterator<ELEMENT> {
    protected final ListIterator<? extends ELEMENT> listIterator;

    protected ReadOnlyListIterator(@Captured ListIterator<? extends ELEMENT> iterator) {
        super(iterator);
        this.listIterator = Objects.requireNonNull(iterator);
    }

    @Pure
    @Capturable
    public static <ELEMENT> ReadOnlyListIterator<ELEMENT> with(@Captured ListIterator<? extends ELEMENT> iterator) {
        return new ReadOnlyListIterator<ELEMENT>(iterator);
    }

    @Override
    @Pure
    public boolean hasPrevious() {
        return this.listIterator.hasPrevious();
    }

    @Override
    @Impure
    public ELEMENT previous() {
        return this.listIterator.previous();
    }

    @Override
    @Pure
    public int nextIndex() {
        return this.listIterator.nextIndex();
    }

    @Override
    @Pure
    public int previousIndex() {
        return this.listIterator.previousIndex();
    }

    @Override
    @Pure
    public final void set(@NonCaptured @Unmodified ELEMENT e) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Pure
    public final void add(@NonCaptured @Unmodified ELEMENT e) {
        throw new UnsupportedOperationException();
    }
}

