/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.iterators;

import java.util.NoSuchElementException;
import net.digitalid.utility.annotations.generics.Specifiable;
import net.digitalid.utility.annotations.method.Impure;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Capturable;
import net.digitalid.utility.annotations.ownership.NonCapturable;
import net.digitalid.utility.annotations.ownership.Shared;
import net.digitalid.utility.functional.iterators.ReadOnlyIterator;
import net.digitalid.utility.validation.annotations.math.NonNegative;
import net.digitalid.utility.validation.annotations.type.Mutable;

@Mutable
public class ReadOnlyArrayIterator<@Specifiable ELEMENT>
extends ReadOnlyIterator<ELEMENT> {
    @Shared
    protected final ELEMENT[] elements;
    @NonNegative
    private int cursor = 0;

    @SafeVarargs
    protected ReadOnlyArrayIterator(ELEMENT ... elements) {
        this.elements = elements;
    }

    @Pure
    @SafeVarargs
    @Capturable
    public static <ELEMENT> ReadOnlyArrayIterator<ELEMENT> with(ELEMENT ... elements) {
        return new ReadOnlyArrayIterator<ELEMENT>(elements);
    }

    @Override
    @Pure
    public boolean hasNext() {
        return this.cursor < this.elements.length;
    }

    @Override
    @Impure
    @NonCapturable
    public ELEMENT next() {
        if (this.hasNext()) {
            return this.elements[this.cursor++];
        }
        throw new NoSuchElementException();
    }

    @Pure
    @NonNegative
    public int nextIndex() {
        if (this.hasNext()) {
            return this.cursor;
        }
        throw new NoSuchElementException();
    }

    @Pure
    public boolean hasPrevious() {
        return this.cursor > 0;
    }

    @Impure
    @NonCapturable
    public ELEMENT previous() {
        if (this.hasPrevious()) {
            return this.elements[--this.cursor];
        }
        throw new NoSuchElementException();
    }

    @Pure
    @NonNegative
    public int previousIndex() {
        if (this.hasPrevious()) {
            return this.cursor - 1;
        }
        throw new NoSuchElementException();
    }
}

