/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.digitalid.utility.annotations.generics.Specifiable;
import net.digitalid.utility.annotations.method.Impure;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Capturable;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.annotations.ownership.NonCapturable;
import net.digitalid.utility.functional.iterators.SingleIteratorBasedIterator;
import net.digitalid.utility.validation.annotations.math.NonNegative;
import net.digitalid.utility.validation.annotations.math.Positive;
import net.digitalid.utility.validation.annotations.type.Mutable;

@Mutable
public class PruningIterator<@Specifiable ELEMENT>
extends SingleIteratorBasedIterator<ELEMENT, ELEMENT> {
    @NonNegative
    protected final int startIndex;
    @Positive
    protected final int endIndex;
    @NonNegative
    private int currentIndex = 0;

    protected PruningIterator(@Captured Iterator<? extends ELEMENT> primaryIterator, @NonNegative int startIndex, @Positive int endIndex) {
        super(primaryIterator);
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    @Pure
    @Capturable
    public static <ELEMENT> PruningIterator<ELEMENT> with(@Captured Iterator<? extends ELEMENT> iterator, @NonNegative int startIndex, @Positive int endIndex) {
        return new PruningIterator<ELEMENT>(iterator, startIndex, endIndex);
    }

    @Override
    @Pure
    public boolean hasNext() {
        while (this.currentIndex < this.startIndex && this.primaryIterator.hasNext()) {
            this.primaryIterator.next();
            ++this.currentIndex;
        }
        return (this.endIndex == Integer.MAX_VALUE || this.currentIndex < this.endIndex) && this.primaryIterator.hasNext();
    }

    @Override
    @Impure
    @NonCapturable
    public ELEMENT next() {
        if (this.hasNext()) {
            if (this.endIndex != Integer.MAX_VALUE) {
                ++this.currentIndex;
            }
            return (ELEMENT)this.primaryIterator.next();
        }
        throw new NoSuchElementException();
    }
}

