/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.iterators;

import java.util.Iterator;
import net.digitalid.utility.annotations.generics.Specifiable;
import net.digitalid.utility.annotations.method.Impure;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Capturable;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.functional.exceptions.IterationExceptionBuilder;
import net.digitalid.utility.functional.failable.FailableUnaryFunction;
import net.digitalid.utility.functional.iterators.SingleIteratorBasedIterator;
import net.digitalid.utility.validation.annotations.type.Mutable;

@Mutable
public class MappingIterator<@Specifiable OUTPUT, @Specifiable INPUT>
extends SingleIteratorBasedIterator<OUTPUT, INPUT> {
    protected final FailableUnaryFunction<? super INPUT, ? extends OUTPUT, ?> function;

    protected MappingIterator(@Captured Iterator<INPUT> primaryIterator, FailableUnaryFunction<? super INPUT, ? extends OUTPUT, ?> function) {
        super(primaryIterator);
        this.function = function;
    }

    @Pure
    @Capturable
    public static <OUTPUT, INPUT> MappingIterator<OUTPUT, INPUT> with(@Captured Iterator<INPUT> iterator, FailableUnaryFunction<? super INPUT, ? extends OUTPUT, ?> function) {
        return new MappingIterator<OUTPUT, INPUT>(iterator, function);
    }

    @Override
    @Pure
    public boolean hasNext() {
        return this.primaryIterator.hasNext();
    }

    @Override
    @Impure
    public OUTPUT next() {
        try {
            return this.function.evaluate(this.primaryIterator.next());
        }
        catch (Exception exception) {
            throw IterationExceptionBuilder.withCause(exception).build();
        }
    }
}

