/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.iterators;

import net.digitalid.utility.annotations.generics.Specifiable;
import net.digitalid.utility.annotations.method.Impure;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Capturable;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.functional.exceptions.IterationExceptionBuilder;
import net.digitalid.utility.functional.failable.FailableUnaryOperator;
import net.digitalid.utility.functional.iterators.InfiniteIterator;
import net.digitalid.utility.validation.annotations.type.Mutable;

@Mutable
public class IteratingIterator<@Specifiable ELEMENT>
extends InfiniteIterator<ELEMENT> {
    private ELEMENT nextElement;
    protected final FailableUnaryOperator<ELEMENT, ?> unaryOperator;

    protected IteratingIterator(@Captured ELEMENT firstElement, FailableUnaryOperator<ELEMENT, ?> unaryOperator) {
        this.nextElement = firstElement;
        this.unaryOperator = unaryOperator;
    }

    @Pure
    @Capturable
    public static <ELEMENT> IteratingIterator<ELEMENT> with(@Captured ELEMENT firstElement, FailableUnaryOperator<ELEMENT, ?> unaryOperator) {
        return new IteratingIterator<ELEMENT>(firstElement, unaryOperator);
    }

    @Override
    @Impure
    public ELEMENT next() {
        try {
            ELEMENT lastElement = this.nextElement;
            this.nextElement = this.unaryOperator.evaluate(lastElement);
            return lastElement;
        }
        catch (Exception exception) {
            throw IterationExceptionBuilder.withCause(exception).build();
        }
    }
}

