/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.iterators;

import net.digitalid.utility.annotations.generics.Specifiable;
import net.digitalid.utility.annotations.method.Impure;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Capturable;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.functional.exceptions.IterationExceptionBuilder;
import net.digitalid.utility.functional.failable.FailableProducer;
import net.digitalid.utility.functional.iterators.InfiniteIterator;
import net.digitalid.utility.validation.annotations.type.Mutable;

@Mutable
public class GeneratingIterator<@Specifiable ELEMENT>
extends InfiniteIterator<ELEMENT> {
    protected final FailableProducer<? extends ELEMENT, ?> producer;

    protected GeneratingIterator(@Captured FailableProducer<? extends ELEMENT, ?> producer) {
        this.producer = producer;
    }

    @Pure
    @Capturable
    public static <ELEMENT> GeneratingIterator<ELEMENT> with(@Captured FailableProducer<? extends ELEMENT, ?> producer) {
        return new GeneratingIterator<ELEMENT>(producer);
    }

    @Override
    @Impure
    @Capturable
    public ELEMENT next() {
        try {
            return this.producer.produce();
        }
        catch (Exception exception) {
            throw IterationExceptionBuilder.withCause(exception).build();
        }
    }
}

