/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.iterators;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import net.digitalid.utility.annotations.generics.Specifiable;
import net.digitalid.utility.annotations.method.Impure;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Capturable;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.annotations.ownership.NonCapturable;
import net.digitalid.utility.functional.iterables.FiniteIterable;
import net.digitalid.utility.functional.iterators.SingleIteratorBasedIterator;
import net.digitalid.utility.validation.annotations.math.NonNegative;
import net.digitalid.utility.validation.annotations.type.Mutable;

@Mutable
public class FlatteningIterator<@Specifiable OUTPUT, @Specifiable INPUT>
extends SingleIteratorBasedIterator<OUTPUT, INPUT> {
    @NonNegative
    protected final int level;
    private INPUT nextElement = null;
    private boolean found = false;
    private Iterator<OUTPUT> subiterator = null;

    protected FlatteningIterator(@Captured Iterator<? extends INPUT> primaryIterator, @NonNegative int level) {
        super(primaryIterator);
        this.level = level;
    }

    @Pure
    @Capturable
    public static <OUTPUT, INPUT> FlatteningIterator<OUTPUT, INPUT> with(@Captured Iterator<? extends INPUT> iterator, @NonNegative int level) {
        return new FlatteningIterator<OUTPUT, INPUT>(iterator, level);
    }

    @Override
    @Pure
    public boolean hasNext() {
        if (this.subiterator != null) {
            if (this.subiterator.hasNext()) {
                return true;
            }
            this.subiterator = null;
        }
        assert (this.subiterator == null);
        if (this.found) {
            return true;
        }
        while (this.primaryIterator.hasNext()) {
            FiniteIterable<Object> iterable;
            Object element = this.primaryIterator.next();
            if (this.level > 0 && (iterable = element instanceof Collection ? FiniteIterable.of((Collection)element) : (element instanceof Object[] ? FiniteIterable.of((Object[])element) : null)) != null) {
                this.subiterator = new FlatteningIterator<OUTPUT, INPUT>(iterable.iterator(), this.level - 1);
                if (this.subiterator.hasNext()) {
                    return true;
                }
                this.subiterator = null;
                continue;
            }
            this.nextElement = element;
            this.found = true;
            return true;
        }
        return false;
    }

    @Override
    @Impure
    @NonCapturable
    public OUTPUT next() {
        if (this.hasNext()) {
            if (this.subiterator != null) {
                return this.subiterator.next();
            }
            this.found = false;
            return (OUTPUT)this.nextElement;
        }
        throw new NoSuchElementException();
    }
}

