/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.iterators;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.digitalid.utility.annotations.generics.Specifiable;
import net.digitalid.utility.annotations.method.Impure;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Capturable;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.annotations.ownership.NonCapturable;
import net.digitalid.utility.functional.exceptions.IterationExceptionBuilder;
import net.digitalid.utility.functional.failable.FailablePredicate;
import net.digitalid.utility.functional.iterators.SingleIteratorBasedIterator;
import net.digitalid.utility.validation.annotations.type.Mutable;

@Mutable
public class FilteringIterator<@Specifiable ELEMENT>
extends SingleIteratorBasedIterator<ELEMENT, ELEMENT> {
    protected final FailablePredicate<? super ELEMENT, ?> predicate;
    private ELEMENT nextElement = null;
    private boolean found = false;

    protected FilteringIterator(@Captured Iterator<? extends ELEMENT> primaryIterator, FailablePredicate<? super ELEMENT, ?> predicate) {
        super(primaryIterator);
        this.predicate = predicate;
    }

    @Pure
    @Capturable
    public static <ELEMENT> FilteringIterator<ELEMENT> with(@Captured Iterator<? extends ELEMENT> iterator, FailablePredicate<? super ELEMENT, ?> predicate) {
        return new FilteringIterator<ELEMENT>(iterator, predicate);
    }

    @Override
    @Pure
    public boolean hasNext() {
        if (this.found) {
            return true;
        }
        try {
            while (this.primaryIterator.hasNext()) {
                Object element = this.primaryIterator.next();
                if (!this.predicate.evaluate(element)) continue;
                this.nextElement = element;
                this.found = true;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            throw IterationExceptionBuilder.withCause(exception).build();
        }
    }

    @Override
    @Impure
    @NonCapturable
    public ELEMENT next() {
        if (this.hasNext()) {
            this.found = false;
            return this.nextElement;
        }
        throw new NoSuchElementException();
    }
}

