/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.iterators;

import java.util.Iterator;
import net.digitalid.utility.annotations.generics.Specifiable;
import net.digitalid.utility.annotations.method.Impure;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Capturable;
import net.digitalid.utility.annotations.ownership.NonCapturable;
import net.digitalid.utility.functional.iterables.FiniteIterable;
import net.digitalid.utility.functional.iterators.ReadOnlyIterator;
import net.digitalid.utility.validation.annotations.type.Mutable;

@Mutable
public class CyclingIterator<@Specifiable ELEMENT>
extends ReadOnlyIterator<ELEMENT> {
    protected final FiniteIterable<? extends ELEMENT> iterable;
    private Iterator<? extends ELEMENT> iterator;
    private final boolean hasNext;

    protected CyclingIterator(FiniteIterable<? extends ELEMENT> iterable) {
        this.iterable = iterable;
        this.iterator = iterable.iterator();
        this.hasNext = this.iterator.hasNext();
    }

    @Pure
    @Capturable
    public static <ELEMENT> CyclingIterator<ELEMENT> with(FiniteIterable<? extends ELEMENT> iterable) {
        return new CyclingIterator<ELEMENT>(iterable);
    }

    @Override
    @Pure
    public boolean hasNext() {
        return this.hasNext;
    }

    @Override
    @Impure
    @NonCapturable
    public ELEMENT next() {
        if (!this.iterator.hasNext()) {
            this.iterator = this.iterable.iterator();
        }
        return this.iterator.next();
    }
}

