/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.iterators;

import java.util.Iterator;
import net.digitalid.utility.annotations.generics.Specifiable;
import net.digitalid.utility.annotations.method.Impure;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Capturable;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.annotations.ownership.NonCapturable;
import net.digitalid.utility.functional.iterators.DoubleIteratorBasedIterator;
import net.digitalid.utility.validation.annotations.type.Mutable;

@Mutable
public class CombiningIterator<@Specifiable ELEMENT>
extends DoubleIteratorBasedIterator<ELEMENT, ELEMENT, ELEMENT> {
    protected CombiningIterator(@Captured Iterator<? extends ELEMENT> primaryIterator, @Captured Iterator<? extends ELEMENT> secondaryIterator) {
        super(primaryIterator, secondaryIterator);
    }

    @Pure
    @Capturable
    public static <ELEMENT> CombiningIterator<ELEMENT> with(@Captured Iterator<? extends ELEMENT> primaryIterator, @Captured Iterator<? extends ELEMENT> secondaryIterator) {
        return new CombiningIterator<ELEMENT>(primaryIterator, secondaryIterator);
    }

    @Override
    @Pure
    public boolean hasNext() {
        return this.primaryIterator.hasNext() || this.secondaryIterator.hasNext();
    }

    @Override
    @Impure
    @NonCapturable
    public ELEMENT next() {
        if (this.primaryIterator.hasNext()) {
            return (ELEMENT)this.primaryIterator.next();
        }
        return (ELEMENT)this.secondaryIterator.next();
    }
}

