/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.iterables;

import net.digitalid.utility.annotations.generics.Specifiable;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.functional.failable.FailablePredicate;
import net.digitalid.utility.functional.failable.FailableProducer;
import net.digitalid.utility.functional.failable.FailableUnaryFunction;
import net.digitalid.utility.functional.failable.FailableUnaryOperator;
import net.digitalid.utility.functional.interfaces.Producer;
import net.digitalid.utility.functional.iterables.FiniteIterable;
import net.digitalid.utility.functional.iterables.FunctionalIterable;
import net.digitalid.utility.functional.iterators.FilteringIterator;
import net.digitalid.utility.functional.iterators.FlatteningIterator;
import net.digitalid.utility.functional.iterators.GeneratingIterator;
import net.digitalid.utility.functional.iterators.IteratingIterator;
import net.digitalid.utility.functional.iterators.MappingIterator;
import net.digitalid.utility.functional.iterators.PruningIterator;
import net.digitalid.utility.functional.iterators.RepeatingIterator;
import net.digitalid.utility.functional.iterators.ZippingIterator;
import net.digitalid.utility.tuples.Pair;
import net.digitalid.utility.validation.annotations.math.NonNegative;
import net.digitalid.utility.validation.annotations.math.Positive;
import net.digitalid.utility.validation.annotations.type.Functional;
import net.digitalid.utility.validation.annotations.type.ReadOnly;

@ReadOnly
@Functional
public interface InfiniteIterable<@Specifiable ELEMENT>
extends FunctionalIterable<ELEMENT> {
    @Pure
    public static <ELEMENT> InfiniteIterable<ELEMENT> repeat(@Captured ELEMENT element) {
        return () -> RepeatingIterator.with(element);
    }

    @Pure
    public static <ELEMENT> InfiniteIterable<ELEMENT> iterate(@Captured ELEMENT firstElement, FailableUnaryOperator<ELEMENT, ?> unaryOperator) {
        return () -> IteratingIterator.with(firstElement, unaryOperator);
    }

    @Pure
    public static <ELEMENT> InfiniteIterable<ELEMENT> generate(@Captured Producer<? extends FailableProducer<? extends ELEMENT, ?>> producer) {
        return () -> GeneratingIterator.with((FailableProducer)producer.produce());
    }

    @Override
    @Pure
    default public boolean isEmpty() {
        return false;
    }

    @Override
    @Pure
    @NonNegative
    default public int size(@Positive int limit) {
        if (limit <= 0) {
            throw new IndexOutOfBoundsException("The limit has to be positive but was " + limit + ".");
        }
        return limit;
    }

    @Override
    @Pure
    default public InfiniteIterable<ELEMENT> filter(FailablePredicate<? super ELEMENT, ?> predicate) {
        return () -> FilteringIterator.with(this.iterator(), predicate);
    }

    @Override
    @Pure
    default public InfiniteIterable<ELEMENT> filterNot(FailablePredicate<? super ELEMENT, ?> predicate) {
        return this.filter((FailablePredicate)predicate.negate());
    }

    @Override
    @Pure
    default public InfiniteIterable<ELEMENT> filterNulls() {
        return this.filter((INPUT element) -> element != null);
    }

    @Override
    @Pure
    default public <TYPE> InfiniteIterable<TYPE> map(FailableUnaryFunction<? super ELEMENT, ? extends TYPE, ?> function) {
        return () -> MappingIterator.with(this.iterator(), function);
    }

    @Override
    @Pure
    default public <TYPE> InfiniteIterable<TYPE> instanceOf(Class<TYPE> type) {
        return this.filter(type::isInstance).map(type::cast);
    }

    @Override
    @Pure
    default public InfiniteIterable<ELEMENT> skip(@Positive int number) {
        return () -> PruningIterator.with(this.iterator(), number, Integer.MAX_VALUE);
    }

    @Override
    @Pure
    default public <TYPE> InfiniteIterable<Pair<ELEMENT, TYPE>> zipShortest(InfiniteIterable<? extends TYPE> iterable) {
        return () -> ZippingIterator.with(this.iterator(), iterable.iterator(), true);
    }

    @Override
    @Pure
    default public <TYPE> InfiniteIterable<Pair<ELEMENT, TYPE>> zipLongest(FiniteIterable<? extends TYPE> iterable) {
        return () -> ZippingIterator.with(this.iterator(), iterable.iterator(), false);
    }

    @Override
    @Pure
    default public <TYPE> InfiniteIterable<TYPE> flatten(@Positive int level) {
        return () -> FlatteningIterator.with(this.iterator(), level);
    }

    @Override
    @Pure
    default public <TYPE> InfiniteIterable<TYPE> flattenOne() {
        return this.flatten(1);
    }

    @Override
    @Pure
    default public <TYPE> InfiniteIterable<TYPE> flattenAll() {
        return this.flatten(Integer.MAX_VALUE);
    }
}

