/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.iterables;

import java.util.Iterator;
import net.digitalid.utility.annotations.generics.Specifiable;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Capturable;
import net.digitalid.utility.annotations.ownership.NonCapturable;
import net.digitalid.utility.functional.failable.FailablePredicate;
import net.digitalid.utility.functional.failable.FailableUnaryFunction;
import net.digitalid.utility.functional.iterables.FiniteIterable;
import net.digitalid.utility.functional.iterables.InfiniteIterable;
import net.digitalid.utility.functional.iterators.PruningIterator;
import net.digitalid.utility.functional.iterators.ReadOnlyIterator;
import net.digitalid.utility.functional.iterators.ZippingIterator;
import net.digitalid.utility.tuples.Pair;
import net.digitalid.utility.validation.annotations.math.NonNegative;
import net.digitalid.utility.validation.annotations.math.Positive;
import net.digitalid.utility.validation.annotations.type.ReadOnly;

@ReadOnly
public interface FunctionalIterable<@Specifiable ELEMENT>
extends Iterable<ELEMENT> {
    @Override
    @Pure
    @Capturable
    public ReadOnlyIterator<ELEMENT> iterator();

    @Pure
    default public boolean isEmpty() {
        return !((ReadOnlyIterator)this.iterator()).hasNext();
    }

    @Pure
    @NonNegative
    default public int size(@Positive int limit) {
        int size;
        if (limit <= 0) {
            throw new IndexOutOfBoundsException("The limit has to be positive but was " + limit + ".");
        }
        Iterator iterator = this.iterator();
        for (size = 0; iterator.hasNext() && size < limit; ++size) {
            iterator.next();
        }
        return size;
    }

    @Pure
    default public boolean hasSize(@NonNegative int number) {
        return this.size(number + 1) == number;
    }

    @Pure
    default public boolean isSingle() {
        return this.hasSize(1);
    }

    @Pure
    default public boolean isEmptyOrSingle() {
        return this.hasSize(1);
    }

    @Pure
    default public boolean sizeAtMost(@NonNegative int value) {
        return this.size(value + 1) <= value;
    }

    @Pure
    default public boolean sizeAtLeast(@Positive int value) {
        return this.size(value) == value;
    }

    @Pure
    @NonCapturable
    default public ELEMENT get(int index) {
        int currentIndex = 0;
        for (Object element : this) {
            if (currentIndex == index) {
                return (ELEMENT)element;
            }
            ++currentIndex;
        }
        throw new IndexOutOfBoundsException("The index has to be non-negative and smaller than the size but was " + index + ".");
    }

    @Pure
    public FunctionalIterable<ELEMENT> filter(FailablePredicate<? super ELEMENT, ?> var1);

    @Pure
    public FunctionalIterable<ELEMENT> filterNot(FailablePredicate<? super ELEMENT, ?> var1);

    @Pure
    public FunctionalIterable<ELEMENT> filterNulls();

    @Pure
    public <TYPE> FunctionalIterable<TYPE> map(FailableUnaryFunction<? super ELEMENT, ? extends TYPE, ?> var1);

    @Pure
    public <TYPE> FunctionalIterable<TYPE> instanceOf(Class<TYPE> var1);

    @Pure
    public FunctionalIterable<ELEMENT> skip(@Positive int var1);

    @Pure
    default public FiniteIterable<ELEMENT> limit(@Positive int number) {
        return () -> PruningIterator.with(this.iterator(), 0, number);
    }

    @Pure
    default public FiniteIterable<ELEMENT> extract(@Positive int startIndex, @Positive int endIndex) {
        return () -> PruningIterator.with(this.iterator(), startIndex, endIndex);
    }

    @Pure
    default public <TYPE> FiniteIterable<Pair<ELEMENT, TYPE>> zipShortest(FiniteIterable<? extends TYPE> iterable) {
        return () -> ZippingIterator.with(this.iterator(), iterable.iterator(), true);
    }

    @Pure
    public <TYPE> FunctionalIterable<Pair<ELEMENT, TYPE>> zipShortest(InfiniteIterable<? extends TYPE> var1);

    @Pure
    public <TYPE> FunctionalIterable<Pair<ELEMENT, TYPE>> zipLongest(FiniteIterable<? extends TYPE> var1);

    @Pure
    default public <TYPE> InfiniteIterable<Pair<ELEMENT, TYPE>> zipLongest(InfiniteIterable<? extends TYPE> iterable) {
        return () -> ZippingIterator.with(this.iterator(), iterable.iterator(), false);
    }

    @Pure
    public <TYPE> FunctionalIterable<TYPE> flatten(@Positive int var1);

    @Pure
    public <TYPE> FunctionalIterable<TYPE> flattenOne();

    @Pure
    public <TYPE> FunctionalIterable<TYPE> flattenAll();
}

