/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.iterables;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import net.digitalid.utility.annotations.generics.Specifiable;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Capturable;
import net.digitalid.utility.annotations.ownership.NonCapturable;
import net.digitalid.utility.annotations.ownership.NonCaptured;
import net.digitalid.utility.annotations.ownership.Shared;
import net.digitalid.utility.annotations.parameter.Modified;
import net.digitalid.utility.annotations.parameter.Unmodified;
import net.digitalid.utility.annotations.state.Modifiable;
import net.digitalid.utility.circumfixes.Circumfix;
import net.digitalid.utility.functional.exceptions.IterationException;
import net.digitalid.utility.functional.failable.FailableBinaryOperator;
import net.digitalid.utility.functional.failable.FailableCollector;
import net.digitalid.utility.functional.failable.FailableConsumer;
import net.digitalid.utility.functional.failable.FailablePredicate;
import net.digitalid.utility.functional.failable.FailableUnaryFunction;
import net.digitalid.utility.functional.interfaces.BinaryOperator;
import net.digitalid.utility.functional.iterables.CollectionBasedIterable;
import net.digitalid.utility.functional.iterables.FunctionalIterable;
import net.digitalid.utility.functional.iterables.InfiniteIterable;
import net.digitalid.utility.functional.iterators.CombiningIterator;
import net.digitalid.utility.functional.iterators.CyclingIterator;
import net.digitalid.utility.functional.iterators.FilteringIterator;
import net.digitalid.utility.functional.iterators.FlatteningIterator;
import net.digitalid.utility.functional.iterators.MappingIterator;
import net.digitalid.utility.functional.iterators.PruningIterator;
import net.digitalid.utility.functional.iterators.ReadOnlyArrayIterator;
import net.digitalid.utility.functional.iterators.ReadOnlyIterableIterator;
import net.digitalid.utility.functional.iterators.ReadOnlyIterator;
import net.digitalid.utility.functional.iterators.ReversingIterator;
import net.digitalid.utility.functional.iterators.ZippingIterator;
import net.digitalid.utility.interfaces.Countable;
import net.digitalid.utility.tuples.Pair;
import net.digitalid.utility.validation.annotations.math.NonNegative;
import net.digitalid.utility.validation.annotations.math.Positive;
import net.digitalid.utility.validation.annotations.math.relative.GreaterThanOrEqualTo;
import net.digitalid.utility.validation.annotations.method.Chainable;
import net.digitalid.utility.validation.annotations.type.Functional;
import net.digitalid.utility.validation.annotations.type.ReadOnly;

@ReadOnly
@Functional
public interface FiniteIterable<@Specifiable ELEMENT>
extends FunctionalIterable<ELEMENT>,
Countable {
    @Pure
    public static <ELEMENT> FiniteIterable<ELEMENT> of(@Shared @Unmodified Collection<? extends ELEMENT> collection) {
        return collection == null ? null : new CollectionBasedIterable<ELEMENT>(collection);
    }

    @Pure
    @SafeVarargs
    public static <ELEMENT> FiniteIterable<ELEMENT> of(ELEMENT ... elements) {
        return () -> ReadOnlyArrayIterator.with(elements);
    }

    @Pure
    @NonNegative
    default public int size() {
        return this.size(Integer.MAX_VALUE);
    }

    @Override
    @Pure
    default public boolean isEmpty() {
        return FunctionalIterable.super.isEmpty();
    }

    @Override
    @Pure
    default public boolean isSingle() {
        return FunctionalIterable.super.isSingle();
    }

    @Override
    @Pure
    default public boolean isEmptyOrSingle() {
        return FunctionalIterable.super.isEmptyOrSingle();
    }

    @Override
    @Pure
    default public FiniteIterable<ELEMENT> filter(FailablePredicate<? super ELEMENT, ?> predicate) {
        return () -> FilteringIterator.with(this.iterator(), predicate);
    }

    @Override
    @Pure
    default public FiniteIterable<ELEMENT> filterNot(FailablePredicate<? super ELEMENT, ?> predicate) {
        return this.filter((FailablePredicate)predicate.negate());
    }

    @Override
    @Pure
    default public FiniteIterable<ELEMENT> filterNulls() {
        return this.filter((INPUT element) -> element != null);
    }

    @Override
    @Pure
    default public <TYPE> FiniteIterable<TYPE> map(FailableUnaryFunction<? super ELEMENT, ? extends TYPE, ?> function) {
        return () -> MappingIterator.with(this.iterator(), function);
    }

    @Override
    @Pure
    default public <TYPE> FiniteIterable<TYPE> instanceOf(Class<TYPE> type) {
        return this.filter(type::isInstance).map(type::cast);
    }

    @Override
    @Pure
    default public FiniteIterable<ELEMENT> skip(@Positive int number) {
        return () -> PruningIterator.with(this.iterator(), number, Integer.MAX_VALUE);
    }

    @Override
    @Pure
    default public <TYPE> FiniteIterable<Pair<ELEMENT, TYPE>> zipShortest(InfiniteIterable<? extends TYPE> iterable) {
        return () -> ZippingIterator.with(this.iterator(), iterable.iterator(), true);
    }

    @Override
    @Pure
    default public <TYPE> FiniteIterable<Pair<ELEMENT, TYPE>> zipLongest(FiniteIterable<? extends TYPE> iterable) {
        return () -> ZippingIterator.with(this.iterator(), iterable.iterator(), false);
    }

    @Override
    @Pure
    default public <TYPE> FiniteIterable<TYPE> flatten(@Positive int level) {
        return () -> FlatteningIterator.with(this.iterator(), level);
    }

    @Override
    @Pure
    default public <TYPE> FiniteIterable<TYPE> flattenOne() {
        return this.flatten(1);
    }

    @Override
    @Pure
    default public <TYPE> FiniteIterable<TYPE> flattenAll() {
        return this.flatten(Integer.MAX_VALUE);
    }

    @Pure
    default public boolean equals(FiniteIterable<?> iterable) {
        if (iterable == null) {
            return false;
        }
        if (iterable == this) {
            return true;
        }
        Iterator thisIterator = this.iterator();
        Iterator thatIterator = iterable.iterator();
        while (((ReadOnlyIterator)thisIterator).hasNext() && ((ReadOnlyIterator)thatIterator).hasNext()) {
            if (Objects.equals(((ReadOnlyIterator)thisIterator).next(), ((ReadOnlyIterator)thatIterator).next())) continue;
            return false;
        }
        return !((ReadOnlyIterator)thisIterator).hasNext() && !((ReadOnlyIterator)thatIterator).hasNext();
    }

    @Pure
    @NonCapturable
    default public ELEMENT getFirst(@NonCaptured @Unmodified ELEMENT defaultElement) {
        Iterator iterator = this.iterator();
        return (ELEMENT)(iterator.hasNext() ? iterator.next() : defaultElement);
    }

    @Pure
    @NonCapturable
    default public ELEMENT getFirstOrNull() {
        return this.getFirst(null);
    }

    @Pure
    @NonCapturable
    default public ELEMENT getFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getFirstOrNull();
    }

    @Pure
    @NonCapturable
    default public ELEMENT getLast(@NonCaptured @Unmodified ELEMENT defaultElement) {
        Object result = defaultElement;
        for (Object element : this) {
            result = element;
        }
        return result;
    }

    @Pure
    @NonCapturable
    default public ELEMENT getLastOrNull() {
        return this.getLast(null);
    }

    @Pure
    @NonCapturable
    default public ELEMENT getLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.getLastOrNull();
    }

    @Pure
    @GreaterThanOrEqualTo(value=-1L)
    default public @GreaterThanOrEqualTo(value=-1L) int indexOf(@NonCaptured @Unmodified Object object) {
        int index = 0;
        for (Object element : this) {
            if (Objects.equals(object, element)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    @Pure
    @GreaterThanOrEqualTo(value=-1L)
    default public @GreaterThanOrEqualTo(value=-1L) int lastIndexOf(@NonCaptured @Unmodified Object object) {
        int lastIndex = -1;
        int currentIndex = 0;
        for (Object element : this) {
            if (Objects.equals(object, element)) {
                lastIndex = currentIndex;
            }
            ++currentIndex;
        }
        return lastIndex;
    }

    @Pure
    @NonNegative
    default public int count(@NonCaptured @Unmodified Object object) {
        int count = 0;
        for (Object element : this) {
            if (!Objects.equals(object, element)) continue;
            ++count;
        }
        return count;
    }

    @Pure
    default public boolean contains(@NonCaptured @Unmodified Object object) {
        for (Object element : this) {
            if (!Objects.equals(object, element)) continue;
            return true;
        }
        return false;
    }

    @Pure
    default public boolean containsAll(FiniteIterable<?> iterable) {
        for (Object element : iterable) {
            if (this.contains(element)) continue;
            return false;
        }
        return true;
    }

    @Pure
    default public boolean containsAll(@NonCaptured @Unmodified Collection<?> collection) {
        for (Object element : collection) {
            if (this.contains(element)) continue;
            return false;
        }
        return true;
    }

    @Pure
    default public boolean containsNull() {
        for (Object element : this) {
            if (element != null) continue;
            return true;
        }
        return false;
    }

    @Pure
    default public boolean containsDuplicates() {
        HashSet set = new HashSet(this.size());
        for (Object element : this) {
            if (set.contains(element)) {
                return true;
            }
            set.add(element);
        }
        return false;
    }

    @Pure
    default public FiniteIterable<ELEMENT> distinct() {
        return () -> ReadOnlyIterableIterator.with(this.toSet().iterator());
    }

    @Pure
    @Chainable
    default public <EXCEPTION extends Exception> FiniteIterable<ELEMENT> doForEach(@NonCaptured @Modified FailableConsumer<? super ELEMENT, ? extends EXCEPTION> action) throws EXCEPTION {
        for (Object element : this) {
            action.consume(element);
        }
        return this;
    }

    @Pure
    default public FiniteIterable<ELEMENT> intersect(FiniteIterable<? super ELEMENT> iterable) {
        return this.filter((INPUT element) -> iterable.contains(element));
    }

    @Pure
    default public FiniteIterable<ELEMENT> exclude(FiniteIterable<? super ELEMENT> iterable) {
        return this.filter((INPUT element) -> !iterable.contains(element));
    }

    @Pure
    default public FiniteIterable<ELEMENT> combine(FiniteIterable<? extends ELEMENT> iterable) {
        return () -> CombiningIterator.with(this.iterator(), iterable.iterator());
    }

    @Pure
    default public InfiniteIterable<ELEMENT> combine(InfiniteIterable<? extends ELEMENT> iterable) {
        return () -> CombiningIterator.with(this.iterator(), iterable.iterator());
    }

    @Pure
    default public InfiniteIterable<ELEMENT> repeated() {
        return () -> CyclingIterator.with(this);
    }

    @Pure
    @NonCapturable
    default public <EXCEPTION extends Exception> ELEMENT findFirst(FailablePredicate<? super ELEMENT, ? extends EXCEPTION> predicate, @NonCaptured @Unmodified ELEMENT defaultElement) throws EXCEPTION {
        for (Object element : this) {
            if (!predicate.evaluate(element)) continue;
            return (ELEMENT)element;
        }
        return defaultElement;
    }

    @Pure
    @NonCapturable
    default public <EXCEPTION extends Exception> ELEMENT findFirst(FailablePredicate<? super ELEMENT, ? extends EXCEPTION> predicate) throws EXCEPTION {
        return this.findFirst(predicate, null);
    }

    @Pure
    @NonCapturable
    default public <EXCEPTION extends Exception> ELEMENT findLast(FailablePredicate<? super ELEMENT, ? extends EXCEPTION> predicate, @NonCaptured @Unmodified ELEMENT defaultElement) throws EXCEPTION {
        Object lastElement = defaultElement;
        for (Object element : this) {
            if (!predicate.evaluate(element)) continue;
            lastElement = element;
        }
        return lastElement;
    }

    @Pure
    @NonCapturable
    default public <EXCEPTION extends Exception> ELEMENT findLast(FailablePredicate<? super ELEMENT, ? extends EXCEPTION> predicate) throws EXCEPTION {
        return this.findLast(predicate, null);
    }

    @Pure
    @NonCapturable
    default public <EXCEPTION extends Exception> ELEMENT findUnique(FailablePredicate<? super ELEMENT, ? extends EXCEPTION> predicate) throws EXCEPTION {
        ELEMENT uniqueElement = null;
        boolean found = false;
        for (Object element : this) {
            if (!predicate.evaluate(element)) continue;
            if (found) {
                throw new NoSuchElementException("More than one elements fulfill the given predicate.");
            }
            uniqueElement = (ELEMENT)element;
            found = true;
        }
        if (found) {
            return uniqueElement;
        }
        throw new NoSuchElementException("No element fulfills the given predicate.");
    }

    @Pure
    default public <EXCEPTION extends Exception> boolean matchAny(FailablePredicate<? super ELEMENT, ? extends EXCEPTION> predicate) throws EXCEPTION {
        for (Object element : this) {
            if (!predicate.evaluate(element)) continue;
            return true;
        }
        return false;
    }

    @Pure
    default public <EXCEPTION extends Exception> boolean matchAll(FailablePredicate<? super ELEMENT, ? extends EXCEPTION> predicate) throws EXCEPTION {
        for (Object element : this) {
            if (predicate.evaluate(element)) continue;
            return false;
        }
        return true;
    }

    @Pure
    default public <EXCEPTION extends Exception> boolean matchNone(FailablePredicate<? super ELEMENT, ? extends EXCEPTION> predicate) throws EXCEPTION {
        return !this.matchAny(predicate);
    }

    @Pure
    @NonCapturable
    default public <EXCEPTION extends Exception> ELEMENT reduce(FailableBinaryOperator<ELEMENT, ? extends EXCEPTION> operator, @NonCaptured @Unmodified ELEMENT element) throws EXCEPTION {
        Iterator iterator = this.iterator();
        if (iterator.hasNext()) {
            Object result = iterator.next();
            while (iterator.hasNext()) {
                result = operator.evaluate(result, iterator.next());
            }
            return (ELEMENT)result;
        }
        return element;
    }

    @Pure
    @NonCapturable
    default public <EXCEPTION extends Exception> ELEMENT reduce(FailableBinaryOperator<ELEMENT, ? extends EXCEPTION> operator) throws EXCEPTION {
        return this.reduce(operator, null);
    }

    @Pure
    @Capturable
    default public <RESULT, COLLECT_EXCEPTION extends Exception, RESULT_EXCEPTION extends Exception> RESULT collect(@NonCaptured @Modified FailableCollector<? super ELEMENT, ? extends RESULT, ? extends COLLECT_EXCEPTION, ? extends RESULT_EXCEPTION> collector) throws COLLECT_EXCEPTION, RESULT_EXCEPTION {
        for (Object element : this) {
            collector.consume(element);
        }
        return collector.getResult();
    }

    @Pure
    default public boolean isOrdered(boolean strictly, boolean ascending) {
        Object lastElement = null;
        for (Object element : this) {
            if (element == null) continue;
            if (lastElement != null && element instanceof Comparable && ((Comparable)element).compareTo(lastElement) * (ascending ? 1 : -1) < (strictly ? 1 : 0)) {
                return false;
            }
            lastElement = element;
        }
        return true;
    }

    @Pure
    default public boolean isAscending() {
        return this.isOrdered(false, true);
    }

    @Pure
    default public boolean isStrictlyAscending() {
        return this.isOrdered(true, true);
    }

    @Pure
    default public boolean isDescending() {
        return this.isOrdered(false, false);
    }

    @Pure
    default public boolean isStrictlyDescending() {
        return this.isOrdered(true, false);
    }

    @Pure
    default public FiniteIterable<ELEMENT> sorted(Comparator<? super ELEMENT> comparator) {
        return () -> {
            List<ELEMENT> list = this.toList();
            Collections.sort(list, comparator);
            return ReadOnlyIterableIterator.with(list.iterator());
        };
    }

    @Pure
    default public FiniteIterable<ELEMENT> sorted() {
        return this.sorted((a, b) -> a == null ? 1 : (b == null ? -1 : ((Comparable)a).compareTo(b)));
    }

    @Pure
    default public FiniteIterable<ELEMENT> reversed() {
        return () -> ReversingIterator.with(this.toGenericArray());
    }

    @Pure
    @NonCapturable
    default public ELEMENT min(Comparator<? super ELEMENT> comparator, @NonCaptured @Unmodified ELEMENT defaultElement) {
        return this.reduce(BinaryOperator.min(comparator), defaultElement);
    }

    @Pure
    @NonCapturable
    default public ELEMENT min(Comparator<? super ELEMENT> comparator) {
        return this.min(comparator, null);
    }

    @Pure
    @NonCapturable
    default public ELEMENT min(@NonCaptured @Unmodified ELEMENT defaultElement) {
        return this.reduce((a, b) -> a == null ? b : (b == null ? a : (((Comparable)a).compareTo(b) <= 0 ? a : b)), defaultElement);
    }

    @Pure
    @NonCapturable
    default public ELEMENT min() {
        return this.min((ELEMENT)null);
    }

    @Pure
    @NonCapturable
    default public ELEMENT max(Comparator<? super ELEMENT> comparator, @NonCaptured @Unmodified ELEMENT defaultElement) {
        return this.reduce(BinaryOperator.max(comparator), defaultElement);
    }

    @Pure
    @NonCapturable
    default public ELEMENT max(Comparator<? super ELEMENT> comparator) {
        return this.max(comparator, null);
    }

    @Pure
    @NonCapturable
    default public ELEMENT max(@NonCaptured @Unmodified ELEMENT defaultElement) {
        return this.reduce((a, b) -> a == null ? b : (b == null ? a : (((Comparable)a).compareTo(b) >= 0 ? a : b)), defaultElement);
    }

    @Pure
    @NonCapturable
    default public ELEMENT max() {
        return this.max((ELEMENT)null);
    }

    @Pure
    default public long sumAsLong() {
        long sum = 0L;
        for (Object element : this) {
            if (!(element instanceof Number)) continue;
            sum += ((Number)element).longValue();
        }
        return sum;
    }

    @Pure
    default public double sumAsDouble() {
        double sum = 0.0;
        for (Object element : this) {
            if (!(element instanceof Number)) continue;
            sum += ((Number)element).doubleValue();
        }
        return sum;
    }

    @Pure
    default public double average() {
        double sum = 0.0;
        int counter = 0;
        for (Object element : this) {
            if (!(element instanceof Number)) continue;
            sum += ((Number)element).doubleValue();
            ++counter;
        }
        return sum / (double)counter;
    }

    @Pure
    default public String join(CharSequence prefix, CharSequence suffix, CharSequence empty, CharSequence delimiter) {
        if (this.isEmpty()) {
            return String.valueOf(empty);
        }
        StringBuilder result = new StringBuilder(prefix);
        boolean first = true;
        for (Object element : this) {
            if (first) {
                first = false;
            } else {
                result.append(delimiter);
            }
            result.append(String.valueOf(element));
        }
        return result.append(suffix).toString();
    }

    @Pure
    default public String join(CharSequence prefix, CharSequence suffix, CharSequence empty) {
        return this.join(prefix, suffix, empty, ", ");
    }

    @Pure
    default public String join(CharSequence prefix, CharSequence suffix) {
        return this.join(prefix, suffix, (CharSequence)(prefix.toString() + suffix.toString()));
    }

    @Pure
    default public String join(Circumfix fixes, CharSequence empty, CharSequence delimiter) {
        if (fixes == null) {
            return this.join("", "", empty, delimiter);
        }
        return this.join(fixes.getPrefix(), fixes.getSuffix(), empty, delimiter);
    }

    @Pure
    default public String join(Circumfix fixes, CharSequence empty) {
        return this.join(fixes, empty, (CharSequence)", ");
    }

    @Pure
    default public String join(Circumfix fixes) {
        return this.join(fixes, (CharSequence)(fixes != null ? fixes.getBoth() : ""));
    }

    @Pure
    default public String join(CharSequence delimiter) {
        return this.join((Circumfix)null, (CharSequence)"", delimiter);
    }

    @Pure
    default public String join() {
        return this.join((Circumfix)null);
    }

    @Pure
    @Capturable
    default public Object[] toArray() {
        Object[] array = new Object[this.size()];
        int index = 0;
        for (Object element : this) {
            array[index++] = element;
        }
        return array;
    }

    @Pure
    @Capturable
    default public ELEMENT[] toGenericArray() {
        return this.toArray();
    }

    @Pure
    @Capturable
    default public <TYPE> TYPE[] toArray(@NonCaptured @Modified TYPE[] array) {
        int size = this.size();
        TYPE[] result = array.length >= size ? array : (Object[])Array.newInstance(array.getClass().getComponentType(), size);
        Iterator iterator = this.iterator();
        for (int i = 0; i < result.length; ++i) {
            if (!iterator.hasNext()) {
                result[i] = null;
                break;
            }
            result[i] = iterator.next();
        }
        return result;
    }

    @Pure
    @Capturable
    @Modifiable
    default public List<ELEMENT> toList() {
        LinkedList result = new LinkedList();
        for (Object element : this) {
            result.add(element);
        }
        return result;
    }

    @Pure
    @Capturable
    @Modifiable
    default public Set<ELEMENT> toSet() {
        LinkedHashSet result = new LinkedHashSet();
        for (Object element : this) {
            result.add(element);
        }
        return result;
    }

    @Pure
    @Capturable
    @Modifiable
    default public <KEY, EXCEPTION extends Exception> Map<KEY, ELEMENT> toMap(FailableUnaryFunction<? super ELEMENT, ? extends KEY, ? extends EXCEPTION> function) throws EXCEPTION {
        LinkedHashMap result = new LinkedHashMap();
        for (Object element : this) {
            result.put(function.evaluate(element), element);
        }
        return result;
    }

    @Pure
    @Capturable
    @Modifiable
    default public <KEY, EXCEPTION extends Exception> Map<KEY, List<ELEMENT>> groupBy(FailableUnaryFunction<? super ELEMENT, ? extends KEY, ? extends EXCEPTION> function) throws EXCEPTION {
        LinkedHashMap result = new LinkedHashMap(this.size());
        for (Object element : this) {
            KEY key = function.evaluate(element);
            LinkedList list = (LinkedList)result.get(key);
            if (list == null) {
                list = new LinkedList();
                result.put(key, list);
            }
            list.add(element);
        }
        return result;
    }

    @Pure
    @Capturable
    default public <EXCEPTION extends Exception> FiniteIterable<ELEMENT> evaluate() throws EXCEPTION {
        try {
            return FiniteIterable.of(this.toList());
        }
        catch (IterationException exception) {
            throw exception.getCause();
        }
    }
}

