/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.iterables;

import net.digitalid.utility.annotations.generics.Specifiable;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.functional.iterables.FiniteIterable;
import net.digitalid.utility.validation.annotations.math.NonNegative;
import net.digitalid.utility.validation.annotations.math.Positive;
import net.digitalid.utility.validation.annotations.type.ReadOnly;

@ReadOnly
public interface CollectionIterable<@Specifiable ELEMENT>
extends FiniteIterable<ELEMENT> {
    @Override
    @Pure
    default public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    @Pure
    @NonNegative
    default public int size(@Positive int limit) {
        return Math.min(this.size(), limit);
    }

    @Override
    @Pure
    @NonNegative
    public int size();
}

