/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.iterables;

import java.util.Collection;
import net.digitalid.utility.annotations.generics.Specifiable;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Capturable;
import net.digitalid.utility.annotations.ownership.Shared;
import net.digitalid.utility.annotations.parameter.Unmodified;
import net.digitalid.utility.functional.iterables.CollectionIterable;
import net.digitalid.utility.functional.iterators.ReadOnlyIterableIterator;
import net.digitalid.utility.functional.iterators.ReadOnlyIterator;
import net.digitalid.utility.validation.annotations.math.NonNegative;
import net.digitalid.utility.validation.annotations.type.ReadOnly;

@ReadOnly
public class CollectionBasedIterable<@Specifiable ELEMENT>
implements CollectionIterable<ELEMENT> {
    @Shared
    private final Collection<? extends ELEMENT> collection;

    protected CollectionBasedIterable(@Shared @Unmodified Collection<? extends ELEMENT> collection) {
        this.collection = collection;
    }

    @Override
    @Pure
    @Capturable
    public ReadOnlyIterator<ELEMENT> iterator() {
        return ReadOnlyIterableIterator.with(this.collection.iterator());
    }

    @Override
    @Pure
    @NonNegative
    public int size() {
        return this.collection.size();
    }
}

