/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.interfaces;

import java.util.Map;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.functional.failable.FailableUnaryOperator;
import net.digitalid.utility.functional.interfaces.UnaryFunction;
import net.digitalid.utility.validation.annotations.type.Functional;
import net.digitalid.utility.validation.annotations.type.Immutable;

@Immutable
@Functional
public interface UnaryOperator<TYPE>
extends UnaryFunction<TYPE, TYPE>,
FailableUnaryOperator<TYPE, RuntimeException> {
    @Pure
    default public UnaryOperator<TYPE> before(UnaryOperator<TYPE> operator) {
        return input -> operator.evaluate(this.evaluate(input));
    }

    @Pure
    default public UnaryOperator<TYPE> after(UnaryOperator<TYPE> operator) {
        return input -> this.evaluate(operator.evaluate(input));
    }

    @Pure
    default public UnaryOperator<TYPE> replaceNull(@Captured TYPE defaultOutput) {
        return input -> input != null ? this.evaluate(input) : defaultOutput;
    }

    @Override
    @Pure
    default public UnaryOperator<TYPE> propagateNull() {
        return this.replaceNull((Object)null);
    }

    @Pure
    public static <TYPE> UnaryOperator<TYPE> with(Map<? super TYPE, ? extends TYPE> map, TYPE defaultValue) {
        return key -> {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            return defaultValue;
        };
    }

    @Pure
    public static <TYPE> UnaryOperator<TYPE> with(Map<? super TYPE, ? extends TYPE> map) {
        return UnaryOperator.with(map, null);
    }

    @Pure
    public static <TYPE> UnaryOperator<TYPE> constant(@Captured TYPE output) {
        return input -> output;
    }

    @Pure
    public static <TYPE> UnaryOperator<TYPE> identity() {
        return input -> input;
    }
}

