/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.interfaces;

import java.util.Map;
import net.digitalid.utility.annotations.generics.Specifiable;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.functional.failable.FailableUnaryFunction;
import net.digitalid.utility.validation.annotations.type.Functional;
import net.digitalid.utility.validation.annotations.type.Immutable;

@Immutable
@Functional
public interface UnaryFunction<@Specifiable INPUT, @Specifiable OUTPUT>
extends FailableUnaryFunction<INPUT, OUTPUT, RuntimeException> {
    @Pure
    default public <FINAL_OUTPUT> UnaryFunction<INPUT, FINAL_OUTPUT> before(UnaryFunction<? super OUTPUT, ? extends FINAL_OUTPUT> function) {
        return input -> function.evaluate((OUTPUT)this.evaluate(input));
    }

    @Pure
    default public <INITIAL_INPUT> UnaryFunction<INITIAL_INPUT, OUTPUT> after(UnaryFunction<? super INITIAL_INPUT, ? extends INPUT> function) {
        return input -> this.evaluate(function.evaluate((Object)input));
    }

    @Pure
    default public UnaryFunction<INPUT, OUTPUT> replaceNull(@Captured OUTPUT defaultValue) {
        return input -> input != null ? this.evaluate(input) : defaultValue;
    }

    @Pure
    default public UnaryFunction<INPUT, OUTPUT> propagateNull() {
        return this.replaceNull((Object)null);
    }

    @Pure
    public static <KEY, VALUE> UnaryFunction<KEY, VALUE> with(Map<? super KEY, ? extends VALUE> map, VALUE defaultValue) {
        return key -> {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            return defaultValue;
        };
    }

    @Pure
    public static <KEY, VALUE> UnaryFunction<KEY, VALUE> with(Map<? super KEY, ? extends VALUE> map) {
        return UnaryFunction.with(map, null);
    }

    @Pure
    public static <OUTPUT> UnaryFunction<Object, OUTPUT> constant(@Captured OUTPUT output) {
        return input -> output;
    }
}

