/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.interfaces;

import net.digitalid.utility.annotations.generics.Specifiable;
import net.digitalid.utility.annotations.method.Impure;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.functional.failable.FailableProducer;
import net.digitalid.utility.functional.interfaces.UnaryFunction;
import net.digitalid.utility.validation.annotations.type.Functional;
import net.digitalid.utility.validation.annotations.type.Mutable;

@Mutable
@Functional
public interface Producer<@Specifiable OUTPUT>
extends FailableProducer<OUTPUT, RuntimeException> {
    @Pure
    default public <FINAL_OUTPUT> Producer<FINAL_OUTPUT> before(UnaryFunction<? super OUTPUT, ? extends FINAL_OUTPUT> function) {
        return () -> function.evaluate((OUTPUT)this.produce());
    }

    @Pure
    default public UnaryFunction<Object, OUTPUT> asFunction() {
        return input -> this.produce();
    }

    @Pure
    default public Producer<OUTPUT> synchronize() {
        return () -> {
            Producer producer = this;
            synchronized (producer) {
                return this.produce();
            }
        };
    }

    @Pure
    default public Producer<OUTPUT> memoize(final long duration) {
        return new Producer<OUTPUT>(){
            private OUTPUT cachedOutput = null;
            private long lastProduction = 0L;

            @Override
            @Impure
            public OUTPUT produce() {
                long currentTime = System.currentTimeMillis();
                if (this.lastProduction == 0L || this.lastProduction + duration < currentTime) {
                    this.cachedOutput = Producer.this.produce();
                    this.lastProduction = currentTime;
                }
                return this.cachedOutput;
            }
        };
    }

    @Pure
    public static <OUTPUT> Producer<OUTPUT> constant(@Captured OUTPUT output) {
        return () -> output;
    }
}

