/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.interfaces;

import net.digitalid.utility.annotations.generics.Specifiable;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.functional.failable.FailablePredicate;
import net.digitalid.utility.functional.interfaces.UnaryFunction;
import net.digitalid.utility.functional.iterables.FiniteIterable;
import net.digitalid.utility.validation.annotations.type.Functional;
import net.digitalid.utility.validation.annotations.type.Immutable;

@Immutable
@Functional
public interface Predicate<@Specifiable INPUT>
extends FailablePredicate<INPUT, RuntimeException> {
    public static final Predicate<Object> ALWAYS_TRUE = input -> true;
    public static final Predicate<Object> ALWAYS_FALSE = input -> false;

    @Pure
    default public Predicate<INPUT> and(Predicate<? super INPUT> predicate) {
        return input -> this.evaluate(input) && predicate.evaluate(input);
    }

    @Pure
    public static <INPUT> Predicate<INPUT> and(FiniteIterable<? extends Predicate<? super INPUT>> predicates) {
        return input -> {
            for (Predicate predicate : predicates) {
                if (predicate.evaluate(input)) continue;
                return false;
            }
            return true;
        };
    }

    @Pure
    default public Predicate<INPUT> or(Predicate<? super INPUT> predicate) {
        return input -> this.evaluate(input) || predicate.evaluate(input);
    }

    @Pure
    @SafeVarargs
    public static <INPUT> Predicate<INPUT> or(Predicate<? super INPUT> ... predicates) {
        return input -> {
            for (Predicate predicate : predicates) {
                if (!predicate.evaluate(input)) continue;
                return true;
            }
            return false;
        };
    }

    @Pure
    public static <INPUT> Predicate<INPUT> or(FiniteIterable<? extends Predicate<? super INPUT>> predicates) {
        return input -> {
            for (Predicate predicate : predicates) {
                if (!predicate.evaluate(input)) continue;
                return true;
            }
            return false;
        };
    }

    @Pure
    default public Predicate<INPUT> negate() {
        return input -> !this.evaluate(input);
    }

    @Pure
    default public <INITIAL_INPUT> Predicate<INITIAL_INPUT> after(UnaryFunction<? super INITIAL_INPUT, ? extends INPUT> function) {
        return input -> this.evaluate(function.evaluate((Object)input));
    }

    @Pure
    default public UnaryFunction<INPUT, Boolean> asFunction() {
        return this::evaluate;
    }

    @Pure
    default public Predicate<INPUT> replaceNull(boolean defaultValue) {
        return input -> input != null ? this.evaluate(input) : defaultValue;
    }
}

