/*
 * Decompiled with CFR 0.152.
 */
package net.digitalid.utility.functional.interfaces;

import net.digitalid.utility.annotations.generics.Specifiable;
import net.digitalid.utility.annotations.method.Pure;
import net.digitalid.utility.annotations.ownership.Capturable;
import net.digitalid.utility.annotations.ownership.Captured;
import net.digitalid.utility.functional.failable.FailableConsumer;
import net.digitalid.utility.functional.interfaces.UnaryFunction;
import net.digitalid.utility.validation.annotations.type.Functional;
import net.digitalid.utility.validation.annotations.type.Mutable;

@Mutable
@Functional
public interface Consumer<@Specifiable INPUT>
extends FailableConsumer<INPUT, RuntimeException> {
    public static final Consumer<Object> DO_NOTHING = input -> {};

    @Pure
    @Capturable
    default public Consumer<INPUT> before(@Captured Consumer<? super INPUT> consumer) {
        return input -> {
            this.consume(input);
            consumer.consume(input);
        };
    }

    @Pure
    @Capturable
    default public Consumer<INPUT> after(@Captured Consumer<? super INPUT> consumer) {
        return input -> {
            consumer.consume(input);
            this.consume(input);
        };
    }

    @Pure
    @Capturable
    default public <INITIAL_INPUT> Consumer<INITIAL_INPUT> after(UnaryFunction<? super INITIAL_INPUT, ? extends INPUT> function) {
        return input -> this.consume(function.evaluate((Object)input));
    }

    @Pure
    default public UnaryFunction<INPUT, Void> asFunction() {
        return input -> {
            this.consume(input);
            return null;
        };
    }

    @Pure
    default public Consumer<INPUT> synchronize() {
        return input -> {
            Consumer consumer = this;
            synchronized (consumer) {
                this.consume(input);
            }
        };
    }
}

